/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.adapter.patch.fixes;

import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.sinytra.adapter.patch.PatchInstance;
import org.sinytra.adapter.patch.analysis.MethodCallAnalyzer;
import org.sinytra.adapter.patch.analysis.selector.AnnotationValueHandle;
import org.sinytra.adapter.patch.api.ClassTransform;
import org.sinytra.adapter.patch.api.Patch;
import org.sinytra.adapter.patch.api.PatchContext;
import org.sinytra.adapter.patch.fixes.BytecodeFixerUpper;
import org.sinytra.adapter.patch.fixes.TypeAdapter;
import org.sinytra.adapter.patch.util.AdapterUtil;
import org.slf4j.Logger;

public class FieldTypeUsageTransformer
implements ClassTransform {
    private static final Logger LOGGER = LogUtils.getLogger();

    @Override
    public Patch.Result apply(ClassNode classNode, @Nullable AnnotationValueHandle<?> annotation, PatchContext context) {
        BytecodeFixerUpper bfu = context.environment().bytecodeFixerUpper();
        boolean applied = false;
        if (bfu != null) {
            HashMap<String, Pair<Type, Type>> classUpdatedTypes = new HashMap<String, Pair<Type, Type>>();
            if (context.targetTypes().size() == 1) {
                Type targetType = context.targetTypes().getFirst();
                for (ListIterator field : classNode.fields) {
                    Pair<Type, Type> updatedTypes;
                    if (!AdapterUtil.isShadowField((FieldNode)field) || (updatedTypes = bfu.getFieldTypeChange(targetType.getInternalName(), ((FieldNode)field).name)) == null) continue;
                    ((FieldNode)field).desc = ((Type)updatedTypes.getSecond()).getDescriptor();
                    classUpdatedTypes.put(((FieldNode)field).name, updatedTypes);
                }
            }
            for (MethodNode method : classNode.methods) {
                for (AbstractInsnNode insn2 : method.instructions) {
                    Pair classUpdatedType;
                    if (!(insn2 instanceof FieldInsnNode)) continue;
                    FieldInsnNode finsn = (FieldInsnNode)insn2;
                    if (finsn.owner.equals(classNode.name) && (classUpdatedType = (Pair)classUpdatedTypes.get(finsn.name)) != null) {
                        applied |= FieldTypeUsageTransformer.runFieldFix(bfu, (Pair<Type, Type>)classUpdatedType, method, finsn);
                        continue;
                    }
                    Pair<Type, Type> updatedTypes = bfu.getFieldTypeChange(finsn.owner, finsn.name);
                    if (updatedTypes == null) continue;
                    applied |= FieldTypeUsageTransformer.runFieldFix(bfu, updatedTypes, method, finsn);
                }
                List<Pair> results = MethodCallAnalyzer.analyzeMethod(method, (m, v) -> m.getOpcode() == 182, (insn, values) -> {
                    AbstractInsnNode valueInsn;
                    if (!values.isEmpty() && (valueInsn = MethodCallAnalyzer.getSingleInsn(values, 0)) instanceof FieldInsnNode) {
                        FieldInsnNode finsn = (FieldInsnNode)valueInsn;
                        return Pair.of((Object)finsn, (Object)insn);
                    }
                    return null;
                });
                for (Pair insn3 : results) {
                    Pair classUpdatedType;
                    FieldInsnNode finsn = (FieldInsnNode)insn3.getFirst();
                    if (!finsn.owner.equals(classNode.name) || (classUpdatedType = (Pair)classUpdatedTypes.get(finsn.name)) == null) continue;
                    ((MethodInsnNode)insn3.getSecond()).owner = ((Type)classUpdatedType.getSecond()).getInternalName();
                    applied = true;
                }
            }
        }
        return applied ? Patch.Result.APPLY : Patch.Result.PASS;
    }

    private static boolean runFieldFix(BytecodeFixerUpper bfu, Pair<Type, Type> updatedTypes, MethodNode method, FieldInsnNode finsn) {
        TypeAdapter typeAdapter = bfu.getTypeAdapter((Type)updatedTypes.getSecond(), (Type)updatedTypes.getFirst());
        if (typeAdapter != null) {
            LOGGER.debug(PatchInstance.MIXINPATCH, "Running fixup for field {}.{}{} in method {}{}", new Object[]{finsn.owner, finsn.name, finsn.desc, method.name, method.desc});
            finsn.desc = ((Type)updatedTypes.getSecond()).getDescriptor();
            typeAdapter.apply(method.instructions, (AbstractInsnNode)finsn);
            return true;
        }
        return false;
    }
}

