/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.connector.transformer.patch;

import java.util.List;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;
import org.sinytra.adapter.patch.api.Patch;
import reloc.net.minecraftforge.fart.api.Transformer;

public class ClassNodeTransformer
implements Transformer {
    private final List<ClassProcessor> processors;

    public ClassNodeTransformer(ClassProcessor ... processors) {
        this.processors = List.of(processors);
    }

    @Override
    public Transformer.ClassEntry process(Transformer.ClassEntry entry) {
        Patch.Result patchResult = Patch.Result.PASS;
        ClassReader reader = new ClassReader(entry.getData());
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        for (ClassProcessor processor : this.processors) {
            patchResult = patchResult.or(processor.process(node));
        }
        if (patchResult != Patch.Result.PASS) {
            ClassWriter writer = new ClassWriter(1 | (patchResult == Patch.Result.COMPUTE_FRAMES ? 2 : 0));
            node.accept((ClassVisitor)writer);
            return Transformer.ClassEntry.create(entry.getName(), entry.getTime(), writer.toByteArray());
        }
        return entry;
    }

    @Override
    public Transformer.ResourceEntry process(Transformer.ResourceEntry entry) {
        for (ClassProcessor processor : this.processors) {
            entry = processor.process(entry);
        }
        return entry;
    }

    public static interface ClassProcessor {
        public Patch.Result process(ClassNode var1);

        default public Transformer.ResourceEntry process(Transformer.ResourceEntry entry) {
            return entry;
        }
    }
}

