/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.incubation.common.block;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class EmptyNestBlock
extends Block {
    protected static final VoxelShape SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0);
    private final Map<Supplier<? extends Item>, Block> NESTS = Maps.newHashMap();

    public EmptyNestBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void addNest(Supplier<? extends Item> egg, Block nest) {
        this.NESTS.put(egg, nest);
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        return !stateIn.canSurvive((LevelReader)worldIn, currentPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        Block nest;
        if (player.mayBuild() && (nest = this.getNest(stack.getItem())) != null) {
            if (!player.getAbilities().instabuild && !worldIn.isClientSide) {
                stack.shrink(1);
            }
            worldIn.setBlock(pos, nest.defaultBlockState(), 3);
            return ItemInteractionResult.sidedSuccess((boolean)worldIn.isClientSide);
        }
        return super.useItemOn(stack, state, worldIn, pos, player, handIn, hit);
    }

    public boolean canSurvive(BlockState state, LevelReader worldIn, BlockPos pos) {
        return worldIn.getBlockState(pos.below()).isSolid();
    }

    public Block getNest(Item item) {
        if (item != Items.AIR) {
            for (Supplier<? extends Item> egg : this.NESTS.keySet()) {
                if (item != egg.get()) continue;
                return this.NESTS.get(egg);
            }
        }
        return null;
    }
}

