/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.incubation.common.levelgen.feature;

import com.mojang.serialization.Codec;
import com.teamabnormals.incubation.common.block.BirdNestBlock;
import com.teamabnormals.incubation.common.levelgen.feature.configurations.NestConfiguration;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class BirdNestFeature
extends Feature<NestConfiguration> {
    public BirdNestFeature(Codec<NestConfiguration> config) {
        super(config);
    }

    public boolean place(FeaturePlaceContext<NestConfiguration> context) {
        BlockState blockstate = (BlockState)((NestConfiguration)context.config()).state.setValue((Property)BirdNestBlock.EGGS, (Comparable)Integer.valueOf(2 + context.random().nextInt(3)));
        WorldGenLevel level = context.level();
        BlockPos pos = context.origin();
        RandomSource random = context.random();
        int y = level.getHeight(Heightmap.Types.WORLD_SURFACE, pos.getX(), pos.getZ());
        BlockPos blockpos = new BlockPos(pos.getX(), y, pos.getZ());
        if (level.isEmptyBlock(blockpos) && level.getBlockState(blockpos.below()).is(Blocks.GRASS_BLOCK)) {
            level.setBlock(blockpos, blockstate, 2);
            EntityType entityType = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(((NestConfiguration)context.config()).entityType);
            if (entityType.create((Level)level.getLevel()) instanceof Mob) {
                for (int i = 0; i < 4; ++i) {
                    Mob entity;
                    double posZ;
                    double posY;
                    double posX = (double)pos.getX() + (random.nextDouble() - random.nextDouble()) * 4.5;
                    if (!level.noCollision(entityType.getSpawnAABB(posX, posY = (double)(pos.getY() + random.nextInt(3) - 1), posZ = (double)pos.getZ() + (random.nextDouble() - random.nextDouble()) * 4.5)) || (entity = (Mob)entityType.create((Level)level.getLevel())) == null || !SpawnPlacements.checkSpawnRules((EntityType)entityType, (ServerLevelAccessor)level, (MobSpawnType)MobSpawnType.STRUCTURE, (BlockPos)BlockPos.containing((double)posX, (double)posY, (double)posZ), (RandomSource)level.getRandom())) continue;
                    entity.moveTo(posX, posY, posZ, random.nextFloat() * 360.0f, 0.0f);
                    entity.finalizeSpawn((ServerLevelAccessor)level, level.getCurrentDifficultyAt(entity.blockPosition()), MobSpawnType.STRUCTURE, null);
                    entity.setBaby(random.nextInt(3) == 0);
                    level.addFreshEntity((Entity)entity);
                }
            }
            return true;
        }
        return false;
    }
}

