/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.incubation.core.data.server;

import com.google.common.collect.ImmutableList;
import com.teamabnormals.incubation.core.registry.IncubationBlocks;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.WritableRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.neoforged.neoforge.common.Tags;

public class IncubationLootTableProvider
extends LootTableProvider {
    public IncubationLootTableProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> provider) {
        super(output, BuiltInLootTables.all(), (List)ImmutableList.of((Object)new LootTableProvider.SubProviderEntry(IncubationBlockLoot::new, LootContextParamSets.BLOCK)), provider);
    }

    protected void validate(WritableRegistry<LootTable> registry, ValidationContext context, ProblemReporter.Collector collector) {
    }

    private static class IncubationBlockLoot
    extends BlockLootSubProvider {
        private static final LootItemCondition.Builder HAS_SHEARS = MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().of(Tags.Items.TOOLS_SHEAR));
        private static final Set<Item> EXPLOSION_RESISTANT = Stream.of(Blocks.AIR).map(ItemLike::asItem).collect(Collectors.toSet());

        protected IncubationBlockLoot(HolderLookup.Provider provider) {
            super(EXPLOSION_RESISTANT, FeatureFlags.REGISTRY.allFlags(), provider);
        }

        public void generate() {
            this.dropSelf((Block)IncubationBlocks.CHICKEN_EGG_CRATE.get());
            this.dropSelf((Block)IncubationBlocks.TURTLE_EGG_CRATE.get());
            this.dropSelf((Block)IncubationBlocks.HAY_NEST.get());
            this.dropOther((Block)IncubationBlocks.HAY_CHICKEN_NEST.get(), (ItemLike)IncubationBlocks.HAY_NEST.get());
            this.dropOther((Block)IncubationBlocks.HAY_DUCK_NEST.get(), (ItemLike)IncubationBlocks.HAY_NEST.get());
            this.dropOther((Block)IncubationBlocks.HAY_TURKEY_NEST.get(), (ItemLike)IncubationBlocks.HAY_NEST.get());
            this.add((Block)IncubationBlocks.TWIG_NEST.get(), this.createTwigNestDrops((Block)IncubationBlocks.TWIG_NEST.get()));
            this.add((Block)IncubationBlocks.TWIG_CHICKEN_NEST.get(), this.createTwigNestDrops((Block)IncubationBlocks.TWIG_CHICKEN_NEST.get()));
            this.add((Block)IncubationBlocks.TWIG_DUCK_NEST.get(), this.createTwigNestDrops((Block)IncubationBlocks.TWIG_DUCK_NEST.get()));
            this.add((Block)IncubationBlocks.TWIG_TURKEY_NEST.get(), this.createTwigNestDrops((Block)IncubationBlocks.TWIG_TURKEY_NEST.get()));
        }

        protected LootTable.Builder createShearsDispatchTable(Block block, LootPoolEntryContainer.Builder<?> builder) {
            return IncubationBlockLoot.createSelfDropDispatchTable((Block)block, (LootItemCondition.Builder)HAS_SHEARS, builder);
        }

        protected LootTable.Builder createTwigNestDrops(Block block) {
            return this.createShearsDispatchTable((Block)IncubationBlocks.TWIG_NEST.get(), (LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)Items.STICK).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f)))));
        }

        public Iterable<Block> getKnownBlocks() {
            return BuiltInRegistries.BLOCK.stream().filter(block -> "incubation".equals(BuiltInRegistries.BLOCK.getKey(block).getNamespace())).collect(Collectors.toSet());
        }
    }
}

