/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.incubation.core.registry;

import com.teamabnormals.incubation.common.levelgen.feature.BirdNestFeature;
import com.teamabnormals.incubation.common.levelgen.feature.configurations.NestConfiguration;
import com.teamabnormals.incubation.core.Incubation;
import com.teamabnormals.incubation.core.other.IncubationConstants;
import com.teamabnormals.incubation.core.registry.IncubationBlocks;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class IncubationFeatures {
    public static final DeferredRegister<Feature<?>> FEATURES = DeferredRegister.create((ResourceKey)Registries.FEATURE, (String)"incubation");
    public static final DeferredHolder<Feature<?>, Feature<NestConfiguration>> BIRD_NEST = FEATURES.register("bird_nest", () -> new BirdNestFeature(NestConfiguration.CODEC));

    public static final class IncubationPlacedFeatures {
        public static final ResourceKey<PlacedFeature> NEST_CHICKEN = IncubationPlacedFeatures.createKey("nest_chicken");
        public static final ResourceKey<PlacedFeature> NEST_DUCK = IncubationPlacedFeatures.createKey("nest_duck");
        public static final ResourceKey<PlacedFeature> NEST_TURKEY = IncubationPlacedFeatures.createKey("nest_turkey");

        public static void bootstrap(BootstrapContext<PlacedFeature> context) {
            IncubationPlacedFeatures.register(context, NEST_CHICKEN, IncubationConfiguredFeatures.NEST_CHICKEN, new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)32), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()});
            IncubationPlacedFeatures.register(context, NEST_DUCK, IncubationConfiguredFeatures.NEST_DUCK, new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)32), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()});
            IncubationPlacedFeatures.register(context, NEST_TURKEY, IncubationConfiguredFeatures.NEST_TURKEY, new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)32), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()});
        }

        public static ResourceKey<PlacedFeature> createKey(String name) {
            return ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)Incubation.location(name));
        }

        public static void register(BootstrapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, ResourceKey<ConfiguredFeature<?, ?>> configuredFeatureHolder, PlacementModifier ... modifiers) {
            context.register(key, (Object)new PlacedFeature((Holder)context.lookup(Registries.CONFIGURED_FEATURE).getOrThrow(configuredFeatureHolder), List.of(modifiers)));
        }
    }

    public static final class IncubationConfiguredFeatures {
        public static final ResourceKey<ConfiguredFeature<?, ?>> NEST_CHICKEN = IncubationConfiguredFeatures.createKey("nest_chicken");
        public static final ResourceKey<ConfiguredFeature<?, ?>> NEST_DUCK = IncubationConfiguredFeatures.createKey("nest_duck");
        public static final ResourceKey<ConfiguredFeature<?, ?>> NEST_TURKEY = IncubationConfiguredFeatures.createKey("nest_turkey");

        public static void bootstrap(BootstrapContext<ConfiguredFeature<?, ?>> context) {
            IncubationConfiguredFeatures.register(context, NEST_CHICKEN, () -> new ConfiguredFeature((Feature)BIRD_NEST.get(), (FeatureConfiguration)new NestConfiguration(((Block)IncubationBlocks.TWIG_CHICKEN_NEST.get()).defaultBlockState(), IncubationConstants.CHICKEN)));
            IncubationConfiguredFeatures.register(context, NEST_DUCK, () -> new ConfiguredFeature((Feature)BIRD_NEST.get(), (FeatureConfiguration)new NestConfiguration(((Block)IncubationBlocks.TWIG_DUCK_NEST.get()).defaultBlockState(), IncubationConstants.DUCK)));
            IncubationConfiguredFeatures.register(context, NEST_TURKEY, () -> new ConfiguredFeature((Feature)BIRD_NEST.get(), (FeatureConfiguration)new NestConfiguration(((Block)IncubationBlocks.TWIG_TURKEY_NEST.get()).defaultBlockState(), IncubationConstants.TURKEY)));
        }

        public static ResourceKey<ConfiguredFeature<?, ?>> createKey(String name) {
            return ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)Incubation.location(name));
        }

        public static void register(BootstrapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> key, Supplier<? extends ConfiguredFeature<?, ?>> configuredFeature) {
            context.register(key, configuredFeature.get());
        }
    }
}

