/*
 * Decompiled with CFR 0.152.
 */
package com.kyanite.deeperdarker.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;

public class WardenHelmetModel<E extends LivingEntity>
extends EntityModel<E>
implements HeadedModel {
    private final ModelPart head;

    public WardenHelmetModel(ModelPart head) {
        this.head = head;
    }

    public static LayerDefinition createBodyModel() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition parts = mesh.getRoot();
        parts.addOrReplaceChild("root", CubeListBuilder.create().texOffs(0, 0).addBox(-11.95f, -13.25f, 0.0f, 8.0f, 10.0f, 0.05f, new CubeDeformation(0.0f)).texOffs(0, 0).mirror().addBox(3.95f, -13.25f, 0.0f, 8.0f, 10.0f, 0.05f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.0f, (float)-0.5f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)16, (int)16);
    }

    public void setupAnim(E entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        netHeadYaw = Mth.clamp((float)netHeadYaw, (float)-30.0f, (float)30.0f);
        headPitch = Mth.clamp((float)headPitch, (float)-25.0f, (float)45.0f);
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.head.xRot = headPitch * ((float)Math.PI / 180);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        this.head.getChild("root").render(poseStack, buffer, packedLight, packedOverlay, color);
    }

    public ModelPart getHead() {
        return this.head;
    }
}

