/*
 * Decompiled with CFR 0.152.
 */
package com.kyanite.deeperdarker.content.datacomponents;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;

public record Transmitter(Optional<GlobalPos> linkedPos, String savedBlock) {
    public static final Codec<Transmitter> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)GlobalPos.CODEC.optionalFieldOf("linked_pos").forGetter(Transmitter::linkedPos), (App)Codec.STRING.optionalFieldOf("saved_block", (Object)"empty").forGetter(Transmitter::savedBlock)).apply((Applicative)instance, Transmitter::new));
    public static final StreamCodec<ByteBuf, Transmitter> STREAM_CODEC = StreamCodec.composite((StreamCodec)GlobalPos.STREAM_CODEC.apply(ByteBufCodecs::optional), Transmitter::linkedPos, (StreamCodec)ByteBufCodecs.STRING_UTF8, Transmitter::savedBlock, Transmitter::new);

    public Transmitter newConnection(Level level, BlockPos pos) {
        Optional<GlobalPos> globalPos = pos != null ? Optional.of(GlobalPos.of((ResourceKey)level.dimension(), (BlockPos)pos)) : Optional.empty();
        String blockName = pos != null ? level.getBlockState(pos).getBlock().getDescriptionId() : "empty";
        return new Transmitter(globalPos, blockName);
    }

    public static Transmitter empty() {
        return new Transmitter(Optional.empty(), "empty");
    }
}

