/*
 * Decompiled with CFR 0.152.
 */
package com.kyanite.deeperdarker.datagen.data;

import com.kyanite.deeperdarker.DeeperDarker;
import com.kyanite.deeperdarker.content.DDBlocks;
import com.kyanite.deeperdarker.content.DDEntities;
import com.kyanite.deeperdarker.content.DDItems;
import com.kyanite.deeperdarker.world.otherside.OthersideBiomes;
import com.kyanite.deeperdarker.world.otherside.OthersideDimension;
import com.kyanite.deeperdarker.world.structures.DDStructures;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.advancements.critereon.ChangeDimensionTrigger;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.KilledTrigger;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.structure.BuiltinStructures;
import net.neoforged.neoforge.common.data.AdvancementProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class DDAdvancements
implements AdvancementProvider.AdvancementGenerator {
    public void generate(HolderLookup.Provider registries, Consumer<AdvancementHolder> saver, ExistingFileHelper existingFileHelper) {
        HolderLookup.RegistryLookup biomes = registries.lookupOrThrow(Registries.BIOME);
        HolderLookup.RegistryLookup structures = registries.lookupOrThrow(Registries.STRUCTURE);
        String id = "advancements.deeperdarker.";
        AdvancementHolder root = Advancement.Builder.advancement().display((ItemLike)Blocks.SCULK, (Component)Component.translatable((String)(id + "root.title")), (Component)Component.translatable((String)(id + "root.description")), DeeperDarker.rl("textures/gui/advancements/root.png"), AdvancementType.TASK, false, false, false).addCriterion("deep_dark", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)biomes.getOrThrow(Biomes.DEEP_DARK)))).save(saver, this.path("root"), existingFileHelper);
        AdvancementHolder findAncientCity = Advancement.Builder.advancement().parent(root).display((ItemLike)Blocks.DEEPSLATE_TILES, (Component)Component.translatable((String)(id + "find_ancient_city.title")), (Component)Component.translatable((String)(id + "find_ancient_city.description")), null, AdvancementType.GOAL, true, true, false).addCriterion("ancient_city", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inStructure((Holder)structures.getOrThrow(BuiltinStructures.ANCIENT_CITY)))).rewards(AdvancementRewards.Builder.experience((int)50)).save(saver, this.path("find_ancient_city"), existingFileHelper);
        AdvancementHolder killWarden = Advancement.Builder.advancement().parent(findAncientCity).display((ItemLike)DDItems.HEART_OF_THE_DEEP.get(), (Component)Component.translatable((String)(id + "kill_warden.title")), (Component)Component.translatable((String)(id + "kill_warden.description")), null, AdvancementType.CHALLENGE, true, true, false).addCriterion("warden", KilledTrigger.TriggerInstance.playerKilledEntity((EntityPredicate.Builder)EntityPredicate.Builder.entity().of(EntityType.WARDEN))).rewards(AdvancementRewards.Builder.experience((int)100)).save(saver, this.path("kill_warden"), existingFileHelper);
        AdvancementHolder enterOtherside = Advancement.Builder.advancement().parent(killWarden).display((ItemLike)Blocks.REINFORCED_DEEPSLATE, (Component)Component.translatable((String)(id + "enter_otherside.title")), (Component)Component.translatable((String)(id + "enter_otherside.description")), null, AdvancementType.TASK, true, true, false).addCriterion("otherside", ChangeDimensionTrigger.TriggerInstance.changedDimensionTo(OthersideDimension.OTHERSIDE_LEVEL)).save(saver, this.path("enter_otherside"), existingFileHelper);
        AdvancementHolder findAncientTemple = Advancement.Builder.advancement().parent(enterOtherside).display((ItemLike)DDBlocks.CUT_SCULK_STONE.get(), (Component)Component.translatable((String)(id + "find_ancient_temple.title")), (Component)Component.translatable((String)(id + "find_ancient_temple.description")), null, AdvancementType.GOAL, true, true, false).addCriterion("ancient_temple", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inStructure((Holder)structures.getOrThrow(DDStructures.ANCIENT_TEMPLE)))).rewards(AdvancementRewards.Builder.experience((int)50)).save(saver, this.path("find_ancient_temple"), existingFileHelper);
        Advancement.Builder.advancement().parent(findAncientTemple).display((ItemLike)DDItems.SCULK_TRANSMITTER.get(), (Component)Component.translatable((String)(id + "obtain_sculk_transmitter.title")), (Component)Component.translatable((String)(id + "obtain_sculk_transmitter.description")), null, AdvancementType.TASK, true, true, false).addCriterion("sculk_transmitter", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)DDItems.SCULK_TRANSMITTER.get()})).save(saver, this.path("obtain_sculk_transmitter"), existingFileHelper);
        Advancement.Builder.advancement().parent(enterOtherside).display((ItemLike)DDItems.SONOROUS_STAFF.get(), (Component)Component.translatable((String)(id + "obtain_sonorous_staff.title")), (Component)Component.translatable((String)(id + "obtain_sonorous_staff.description")), null, AdvancementType.TASK, true, true, false).addCriterion("sonorous_staff", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)DDItems.SONOROUS_STAFF.get()})).save(saver, this.path("obtain_sonorous_staff"), existingFileHelper);
        Advancement.Builder.advancement().parent(enterOtherside).display((ItemLike)DDItems.WARDEN_BOOTS.get(), (Component)Component.translatable((String)(id + "explore_otherside.title")), (Component)Component.translatable((String)(id + "explore_otherside.description")), null, AdvancementType.CHALLENGE, true, true, false).addCriterion("deeplands", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)biomes.getOrThrow(OthersideBiomes.DEEPLANDS)))).addCriterion("echoing_forest", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)biomes.getOrThrow(OthersideBiomes.ECHOING_FOREST)))).addCriterion("blooming_caverns", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)biomes.getOrThrow(OthersideBiomes.BLOOMING_CAVERNS)))).addCriterion("overcast_columns", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)biomes.getOrThrow(OthersideBiomes.OVERCAST_COLUMNS)))).requirements(AdvancementRequirements.Strategy.AND).rewards(AdvancementRewards.Builder.experience((int)300)).save(saver, this.path("explore_otherside"), existingFileHelper);
        Advancement.Builder.advancement().parent(enterOtherside).display((ItemLike)DDItems.WARDEN_SWORD.get(), (Component)Component.translatable((String)(id + "kill_all_sculk_mobs.title")), (Component)Component.translatable((String)(id + "kill_all_sculk_mobs.description")), null, AdvancementType.CHALLENGE, true, true, false).addCriterion("phantom", KilledTrigger.TriggerInstance.playerKilledEntity((EntityPredicate.Builder)EntityPredicate.Builder.entity().of(EntityType.PHANTOM))).addCriterion("warden", KilledTrigger.TriggerInstance.playerKilledEntity((EntityPredicate.Builder)EntityPredicate.Builder.entity().of(EntityType.WARDEN))).addCriterion("angler_fish", KilledTrigger.TriggerInstance.playerKilledEntity((EntityPredicate.Builder)EntityPredicate.Builder.entity().of((EntityType)DDEntities.ANGLER_FISH.get()))).addCriterion("sculk_centipede", KilledTrigger.TriggerInstance.playerKilledEntity((EntityPredicate.Builder)EntityPredicate.Builder.entity().of((EntityType)DDEntities.SCULK_CENTIPEDE.get()))).addCriterion("sculk_leech", KilledTrigger.TriggerInstance.playerKilledEntity((EntityPredicate.Builder)EntityPredicate.Builder.entity().of((EntityType)DDEntities.SCULK_LEECH.get()))).addCriterion("sculk_snapper", KilledTrigger.TriggerInstance.playerKilledEntity((EntityPredicate.Builder)EntityPredicate.Builder.entity().of((EntityType)DDEntities.SCULK_SNAPPER.get()))).addCriterion("shattered", KilledTrigger.TriggerInstance.playerKilledEntity((EntityPredicate.Builder)EntityPredicate.Builder.entity().of((EntityType)DDEntities.SHATTERED.get()))).addCriterion("shriek_worm", KilledTrigger.TriggerInstance.playerKilledEntity((EntityPredicate.Builder)EntityPredicate.Builder.entity().of((EntityType)DDEntities.SHRIEK_WORM.get()))).addCriterion("stalker", KilledTrigger.TriggerInstance.playerKilledEntity((EntityPredicate.Builder)EntityPredicate.Builder.entity().of((EntityType)DDEntities.STALKER.get()))).requirements(AdvancementRequirements.Strategy.AND).rewards(AdvancementRewards.Builder.experience((int)100)).save(saver, this.path("kill_all_sculk_mobs"), existingFileHelper);
        AdvancementHolder obtainReinforcedEchoShard = Advancement.Builder.advancement().parent(killWarden).display((ItemLike)DDItems.REINFORCED_ECHO_SHARD.get(), (Component)Component.translatable((String)(id + "obtain_reinforced_echo_shard.title")), (Component)Component.translatable((String)(id + "obtain_reinforced_echo_shard.description")), null, AdvancementType.TASK, true, true, false).addCriterion("reinforced_echo_shard", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)DDItems.REINFORCED_ECHO_SHARD.get()})).save(saver, this.path("obtain_reinforced_echo_shard"), existingFileHelper);
        Advancement.Builder.advancement().parent(obtainReinforcedEchoShard).display((ItemLike)DDItems.WARDEN_CHESTPLATE.get(), (Component)Component.translatable((String)(id + "warden_armor.title")), (Component)Component.translatable((String)(id + "warden_armor.description")), null, AdvancementType.CHALLENGE, true, true, false).addCriterion("warden_armor", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)DDItems.WARDEN_HELMET.get(), (ItemLike)DDItems.WARDEN_CHESTPLATE.get(), (ItemLike)DDItems.WARDEN_LEGGINGS.get(), (ItemLike)DDItems.WARDEN_BOOTS.get()})).rewards(AdvancementRewards.Builder.experience((int)100)).save(saver, this.path("warden_armor"), existingFileHelper);
    }

    private ResourceLocation path(String name) {
        return DeeperDarker.rl("main/" + name);
    }
}

