/*
 * Decompiled with CFR 0.152.
 */
package github.nitespring.monsterplus.client.render.entities.mobs.ancienthero;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import github.nitespring.monsterplus.common.entity.ancienthero.AncientHero;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.SkeletonModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;

public class AncientHeroModel<T extends AncientHero>
extends SkeletonModel<T> {
    private final ModelPart head;
    private final ModelPart mouth;
    private final ModelPart hat;
    private final ModelPart crest;
    private final ModelPart body;
    private final ModelPart body_armour;
    private final ModelPart cape;
    private final ModelPart left_arm;
    private final ModelPart left_arm_armour;
    private final ModelPart right_arm;
    private final ModelPart right_arm_armour;
    private final ModelPart left_leg;
    private final ModelPart right_leg;

    public AncientHeroModel(ModelPart part) {
        super(part);
        this.head = part.getChild("head");
        this.mouth = this.head.getChild("mouth");
        this.hat = part.getChild("hat");
        this.body = part.getChild("body");
        this.right_arm = part.getChild("right_arm");
        this.left_arm = part.getChild("left_arm");
        this.right_leg = part.getChild("right_leg");
        this.left_leg = part.getChild("left_leg");
        this.crest = this.hat.getChild("crest");
        this.body_armour = this.body.getChild("body_armour");
        this.cape = this.body.getChild("cape");
        this.left_arm_armour = this.left_arm.getChild("left_arm_armour");
        this.right_arm_armour = this.right_arm.getChild("right_arm_armour");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = HumanoidModel.createMesh((CubeDeformation)CubeDeformation.NONE, (float)0.0f);
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition mouth = head.addOrReplaceChild("mouth", CubeListBuilder.create().texOffs(0, 48).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(-0.25f)), PartPose.offset((float)0.0f, (float)25.0f, (float)0.0f));
        PartDefinition hat = partdefinition.addOrReplaceChild("hat", CubeListBuilder.create().texOffs(32, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.5f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition crest = hat.addOrReplaceChild("crest", CubeListBuilder.create().texOffs(32, 60).addBox(-1.0f, -10.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(40, 40).addBox(0.0f, -20.0f, -6.0f, 0.0f, 12.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(16, 16).addBox(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition body_armour = body.addOrReplaceChild("body_armour", CubeListBuilder.create().texOffs(16, 32).addBox(-4.0f, -24.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.5f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition cape = body.addOrReplaceChild("cape", CubeListBuilder.create().texOffs(46, 35).addBox(-4.0f, 0.0f, 2.0f, 8.0f, 16.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)2.0f));
        PartDefinition left_arm = partdefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(48, 16).mirror().addBox(-1.0f, -2.0f, -1.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)5.0f, (float)2.0f, (float)0.0f));
        PartDefinition left_arm_armour = left_arm.addOrReplaceChild("left_arm_armour", CubeListBuilder.create().texOffs(0, 40).addBox(-1.0f, -2.75f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.25f)).texOffs(24, 49).addBox(-1.0f, -7.0f, 0.0f, 7.0f, 7.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition right_arm = partdefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(40, 16).addBox(-1.0f, -2.0f, -1.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-5.0f, (float)2.0f, (float)0.0f));
        PartDefinition right_arm_armour = right_arm.addOrReplaceChild("right_arm_armour", CubeListBuilder.create().texOffs(0, 40).mirror().addBox(-3.0f, -2.75f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.25f)).mirror(false).texOffs(24, 49).mirror().addBox(-6.0f, -7.0f, 0.0f, 7.0f, 7.0f, 0.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition left_leg = partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(8, 16).mirror().addBox(-1.0f, 0.0f, -1.1f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)2.0f, (float)12.0f, (float)0.1f));
        PartDefinition right_leg = partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(0, 16).addBox(-1.0f, 0.0f, -1.1f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)12.0f, (float)0.1f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        this.cape.copyFrom(this.body);
        if (entity.getTarget() != null) {
            this.head.y = -2.0f;
            this.hat.y = -2.0f;
            this.mouth.y = 3.0f + 1.5f * limbSwingAmount + (float)(1.5 * Math.cos((double)ageInTicks * 0.25));
        } else {
            this.mouth.y = 1.0f + 1.25f * limbSwingAmount + (float)(0.5 * Math.cos((double)ageInTicks * 0.1));
        }
        this.cape.xRot = 0.25f * limbSwingAmount + (15.0f + (float)((10.0 + (double)Math.abs(limbSwingAmount)) * Math.cos((double)ageInTicks * 0.1 * (double)(1.0f + 0.05f * limbSwingAmount)))) * ((float)Math.PI / 180);
        switch (((AncientHero)((Object)entity)).getEntityState()) {
            case 1: {
                this.hat.visible = false;
                this.head.visible = true;
                this.body_armour.visible = true;
                this.right_arm_armour.visible = true;
                this.left_arm_armour.visible = true;
                this.cape.visible = true;
                break;
            }
            case 2: {
                this.hat.visible = false;
                this.head.visible = false;
                this.body_armour.visible = true;
                this.right_arm_armour.visible = true;
                this.left_arm_armour.visible = true;
                this.cape.visible = true;
                break;
            }
            case 3: {
                this.hat.visible = false;
                this.head.visible = false;
                this.body_armour.visible = false;
                this.right_arm_armour.visible = false;
                this.left_arm_armour.visible = false;
                this.cape.visible = false;
                break;
            }
            default: {
                this.hat.visible = true;
                this.head.visible = true;
                this.body_armour.visible = true;
                this.right_arm_armour.visible = true;
                this.left_arm_armour.visible = true;
                this.cape.visible = true;
            }
        }
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int colour) {
        super.renderToBuffer(poseStack, vertexConsumer, packedLight, packedOverlay, colour);
    }
}

