/*
 * Decompiled with CFR 0.152.
 */
package github.nitespring.monsterplus.client.render.entities.mobs.eyeball;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import github.nitespring.monsterplus.common.entity.DemonEye;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;

public class DemonEyeModel<T extends DemonEye>
extends EntityModel<T> {
    private final ModelPart root;
    private final ModelPart eye;
    private final ModelPart tendrils;
    private final ModelPart tendrils_child;

    public DemonEyeModel(ModelPart part) {
        this.root = part.getChild("root");
        this.eye = this.root.getChild("eye");
        this.tendrils = this.root.getChild("tendrils");
        this.tendrils_child = this.tendrils.getChild("tendrils_child");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition root = partdefinition.addOrReplaceChild("root", CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f), PartPose.ZERO);
        PartDefinition eye = root.addOrReplaceChild("eye", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(0, 16).addBox(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.5f)), PartPose.offset((float)0.0f, (float)20.0f, (float)0.0f));
        PartDefinition tendrils = root.addOrReplaceChild("tendrils", CubeListBuilder.create().texOffs(44, 0).addBox(-3.0f, -3.0f, 0.0f, 6.0f, 6.0f, 4.0f, new CubeDeformation(-0.25f)), PartPose.offset((float)0.0f, (float)20.0f, (float)4.0f));
        PartDefinition tendrils_child = tendrils.addOrReplaceChild("tendrils_child", CubeListBuilder.create().texOffs(40, 14).addBox(-2.0f, -2.0f, -1.0f, 4.0f, 4.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(32, 10).addBox(0.0f, -3.0f, -1.0f, 0.0f, 6.0f, 16.0f, new CubeDeformation(0.0f)).texOffs(16, 0).addBox(-3.0f, 0.0f, -1.0f, 6.0f, 0.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)2.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.eye.xScale = ((DemonEye)((Object)entity)).getEyeScale();
        this.eye.yScale = ((DemonEye)((Object)entity)).getEyeScale();
        this.eye.zScale = ((DemonEye)((Object)entity)).getEyeScale();
        this.eye.yRot = 0.5f * netHeadYaw * ((float)Math.PI / 180);
        this.eye.xRot = -0.15f * headPitch * ((float)Math.PI / 180);
        this.tendrils.copyFrom(this.eye);
        this.tendrils_child.yRot = (float)(15.0 * Math.cos((double)ageInTicks * 0.1) * 0.01745329238474369 - (double)(0.75f * netHeadYaw * ((float)Math.PI / 180)) + (double)(0.5f * (entity.getYRot() - ((DemonEye)((Object)entity)).yRotO) * ((float)Math.PI / 180)));
        this.tendrils_child.xRot = -0.5f * headPitch * ((float)Math.PI / 180) + 0.25f * (entity.getXRot() - ((DemonEye)((Object)entity)).xRotO) * ((float)Math.PI / 180);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int colour) {
        this.eye.render(poseStack, vertexConsumer, packedLight, packedOverlay, colour);
        this.tendrils.render(poseStack, vertexConsumer, packedLight, packedOverlay, colour);
    }
}

