/*
 * Decompiled with CFR 0.152.
 */
package github.nitespring.monsterplus.client.render.entities.mobs.glowskeleton;

import github.nitespring.monsterplus.ClientListener;
import github.nitespring.monsterplus.client.render.entities.mobs.glowskeleton.GlowSkeletonModel;
import github.nitespring.monsterplus.common.entity.GlowSkeleton;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.monster.AbstractSkeleton;

public class GlowSkeletonRenderer<T extends GlowSkeleton>
extends HumanoidMobRenderer<T, GlowSkeletonModel<T>> {
    private static final ResourceLocation GLOW_SKELETON_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"monsterplus", (String)"textures/entities/glow_skeleton.png");

    public GlowSkeletonRenderer(EntityRendererProvider.Context p_174380_) {
        this(p_174380_, ClientListener.GLOW_SKELETON_LAYER, ModelLayers.SKELETON_INNER_ARMOR, ModelLayers.SKELETON_OUTER_ARMOR);
    }

    public GlowSkeletonRenderer(EntityRendererProvider.Context p_174382_, ModelLayerLocation p_174383_, ModelLayerLocation p_174384_, ModelLayerLocation p_174385_) {
        super(p_174382_, new GlowSkeletonModel(p_174382_.bakeLayer(p_174383_)), 0.5f);
        this.addLayer((RenderLayer)new HumanoidArmorLayer((RenderLayerParent)this, new GlowSkeletonModel(p_174382_.bakeLayer(p_174384_)), new GlowSkeletonModel(p_174382_.bakeLayer(p_174385_)), p_174382_.getModelManager()));
    }

    public ResourceLocation getTextureLocation(T p_115941_) {
        return GLOW_SKELETON_LOCATION;
    }

    protected int getBlockLightLevel(T entity, BlockPos p_174147_) {
        int b = ((GlowSkeleton)((Object)entity)).getBrightTicksRemaining();
        int max = 15;
        int min = 10;
        if (b >= 80) {
            return max;
        }
        if (b >= 10) {
            return max - (71 - (b - 10)) / max;
        }
        return min;
    }

    protected boolean isShaking(AbstractSkeleton p_174389_) {
        return p_174389_.isShaking();
    }
}

