/*
 * Decompiled with CFR 0.152.
 */
package github.nitespring.monsterplus.client.render.entities.mobs.wisp;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import github.nitespring.monsterplus.ClientListener;
import github.nitespring.monsterplus.client.render.entities.mobs.wisp.SoulOverlayLayer;
import github.nitespring.monsterplus.client.render.entities.mobs.wisp.WispModel;
import github.nitespring.monsterplus.common.entity.Soul;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public class SoulRenderer<T extends Soul>
extends MobRenderer<T, WispModel<T>> {
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"monsterplus", (String)"textures/entities/soul.png");
    public static final ResourceLocation OVERLAY = ResourceLocation.fromNamespaceAndPath((String)"monsterplus", (String)"textures/entities/soul_outer.png");

    public SoulRenderer(EntityRendererProvider.Context context) {
        super(context, new WispModel(context.bakeLayer(ClientListener.WISP_INNER_LAYER)), 0.75f);
        this.addLayer(new SoulOverlayLayer(this, context.getModelSet()));
    }

    public SoulRenderer(EntityRendererProvider.Context context, WispModel<T> e, float f) {
        super(context, e, f);
    }

    public void render(T pEntity, float pEntityYaw, float pPartialTicks, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight) {
        pPoseStack.pushPose();
        float scaleFactor = 0.4f;
        pPoseStack.scale(scaleFactor, scaleFactor, scaleFactor);
        super.render(pEntity, pEntityYaw, pPartialTicks, pPoseStack, pBuffer, pPackedLight);
        pPoseStack.popPose();
    }

    public ResourceLocation getTextureLocation(T e) {
        return TEXTURE;
    }

    protected int getBlockLightLevel(T e, BlockPos pos) {
        return Math.min(super.getBlockLightLevel(e, pos) + 13, 15);
    }

    protected float getShadowRadius(T pEntity) {
        return 0.0f;
    }

    protected void setupRotations(T p_116035_, PoseStack p_116036_, float p_116037_, float p_116038_, float p_116039_, float p_335360_) {
        float $$6 = Mth.lerp((float)p_116039_, (float)((Soul)((Object)p_116035_)).xBodyRotO, (float)((Soul)((Object)p_116035_)).xBodyRot);
        float $$7 = Mth.lerp((float)p_116039_, (float)((Soul)((Object)p_116035_)).zBodyRotO, (float)((Soul)((Object)p_116035_)).zBodyRot);
        p_116036_.translate(0.0f, 0.5f, 0.0f);
        p_116036_.mulPose(Axis.YP.rotationDegrees(180.0f - p_116038_));
        p_116036_.mulPose(Axis.XP.rotationDegrees($$6));
        p_116036_.mulPose(Axis.YP.rotationDegrees($$7));
        p_116036_.translate(0.0f, -1.2f, 0.0f);
    }

    protected float getBob(T p_116032_, float p_116033_) {
        return Mth.lerp((float)p_116033_, (float)((Soul)((Object)p_116032_)).oldTentacleAngle, (float)((Soul)((Object)p_116032_)).tentacleAngle);
    }

    @Nullable
    protected RenderType getRenderType(T pLivingEntity, boolean pBodyVisible, boolean pTranslucent, boolean pGlowing) {
        if (pTranslucent) {
            return RenderType.itemEntityTranslucentCull((ResourceLocation)this.getTextureLocation(pLivingEntity));
        }
        if (pBodyVisible) {
            return RenderType.entityTranslucent((ResourceLocation)this.getTextureLocation(pLivingEntity));
        }
        return pGlowing ? RenderType.outline((ResourceLocation)this.getTextureLocation(pLivingEntity)) : null;
    }
}

