/*
 * Decompiled with CFR 0.152.
 */
package github.nitespring.monsterplus.client.render.entities.mobs.wisp;

import java.util.Arrays;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.Entity;

public class WispModel<T extends Entity>
extends HierarchicalModel<T> {
    private final ModelPart[] tentacles = new ModelPart[8];
    private final ModelPart root;

    public WispModel(ModelPart pRoot) {
        this.root = pRoot;
        Arrays.setAll(this.tentacles, p_170995_ -> pRoot.getChild(WispModel.createTentacleName(p_170995_)));
    }

    private static String createTentacleName(int pIndex) {
        return "tentacle" + pIndex;
    }

    public static LayerDefinition createInnerLayer() {
        return WispModel.createBodyLayer(new CubeDeformation(-0.48f), CubeDeformation.NONE);
    }

    public static LayerDefinition createOuterLayer() {
        return WispModel.createBodyLayer(new CubeDeformation(2.02f), new CubeDeformation(0.5f));
    }

    public static LayerDefinition createBodyLayer(CubeDeformation cubedeformation1, CubeDeformation cubedeformation2) {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        int i = -16;
        partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-7.0f, -8.0f, -7.0f, 14.0f, 16.0f, 14.0f, cubedeformation1), PartPose.offset((float)0.0f, (float)8.0f, (float)0.0f));
        int j = 8;
        CubeListBuilder cubelistbuilder = CubeListBuilder.create().texOffs(48, 0).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 12.0f, 2.0f, cubedeformation2);
        for (int k = 0; k < 8; ++k) {
            double d0 = (double)k * Math.PI * 2.0 / 8.0;
            float f = (float)Math.cos(d0) * 5.0f;
            float f1 = 15.0f;
            float f2 = (float)Math.sin(d0) * 5.0f;
            d0 = (double)k * Math.PI * -2.0 / 8.0 + 1.5707963267948966;
            float f3 = (float)d0;
            partdefinition.addOrReplaceChild(WispModel.createTentacleName(k), cubelistbuilder, PartPose.offsetAndRotation((float)f, (float)15.0f, (float)f2, (float)0.0f, (float)f3, (float)0.0f));
        }
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void setupAnim(T pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        for (ModelPart modelpart : this.tentacles) {
            modelpart.xRot = pAgeInTicks;
        }
    }

    public ModelPart root() {
        return this.root;
    }
}

