/*
 * Decompiled with CFR 0.152.
 */
package github.nitespring.monsterplus.common.entity;

import github.nitespring.monsterplus.common.entity.CustomSpellcaster;
import github.nitespring.monsterplus.common.entity.Eye;
import github.nitespring.monsterplus.common.entity.SpectralSkeleton;
import github.nitespring.monsterplus.common.entity.projectiles.PurpleFireball;
import github.nitespring.monsterplus.common.entity.projectiles.SpikeCountdown;
import github.nitespring.monsterplus.config.CommonConfig;
import github.nitespring.monsterplus.core.init.EntityInit;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.SpellcasterIllager;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class Abyssologer
extends CustomSpellcaster {
    public Abyssologer(EntityType<? extends SpellcasterIllager> p_33724_, Level p_33725_) {
        super(p_33724_, p_33725_);
        this.xpReward = 10;
    }

    public boolean canJoinRaid() {
        return super.canJoinRaid();
    }

    protected SoundEvent getCastingSoundEvent() {
        return SoundEvents.EVOKER_CAST_SPELL;
    }

    public SoundEvent getCelebrateSound() {
        return SoundEvents.EVOKER_CELEBRATE;
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new CastingSpellGoal());
        this.goalSelector.addGoal(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Mob.class, 8.0f, 0.6, 1.0, p_28879_ -> p_28879_ == this.getTarget()));
        this.goalSelector.addGoal(4, (Goal)new SummonEyeSpellGoal());
        this.goalSelector.addGoal(4, (Goal)new SummonSkeletonSpellGoal());
        this.goalSelector.addGoal(4, (Goal)new BlindnessSpellGoal());
        this.goalSelector.addGoal(5, (Goal)new SpikeSpellGoal());
        this.goalSelector.addGoal(5, (Goal)new FireballSpellGoal());
        this.goalSelector.addGoal(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.goalSelector.addGoal(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.goalSelector.addGoal(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true).setUnseenMemoryTicks(300));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false).setUnseenMemoryTicks(300));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, false));
    }

    public void applyRaidBuffs(ServerLevel serverLevel, int i, boolean b) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MOVEMENT_SPEED, 0.5).add(Attributes.MAX_HEALTH, 30.0).add(Attributes.FOLLOW_RANGE, 24.0);
    }

    public boolean isAlliedTo(Entity p_32665_) {
        if (p_32665_ == null) {
            return false;
        }
        if (p_32665_ == this) {
            return true;
        }
        if (super.isAlliedTo(p_32665_)) {
            return true;
        }
        if (p_32665_ instanceof Eye) {
            return this.isAlliedTo((Entity)((Eye)p_32665_).getOwner());
        }
        if (p_32665_ instanceof SpectralSkeleton) {
            return this.isAlliedTo((Entity)((SpectralSkeleton)p_32665_).getOwner());
        }
        if (p_32665_ instanceof LivingEntity && ((LivingEntity)p_32665_).getType().is(EntityTypeTags.ILLAGER)) {
            return this.getTeam() == null && p_32665_.getTeam() == null;
        }
        return false;
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.EVOKER_AMBIENT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.EVOKER_DEATH;
    }

    protected SoundEvent getHurtSound(DamageSource p_32654_) {
        return SoundEvents.EVOKER_HURT;
    }

    public static boolean checkAbyssologerSpawnRules(EntityType<? extends Monster> p_219014_, ServerLevelAccessor p_219015_, MobSpawnType p_219016_, BlockPos blockPos, RandomSource p_219018_) {
        return p_219015_.getDifficulty() != Difficulty.PEACEFUL && Abyssologer.isDarkEnoughToSpawn((ServerLevelAccessor)p_219015_, (BlockPos)blockPos, (RandomSource)p_219018_) && Abyssologer.checkMobSpawnRules(p_219014_, (LevelAccessor)p_219015_, (MobSpawnType)p_219016_, (BlockPos)blockPos, (RandomSource)p_219018_) && blockPos.getY() <= 40 && (Boolean)CommonConfig.spawn_abyssologer.get() != false;
    }

    class CastingSpellGoal
    extends SpellcasterIllager.SpellcasterCastingSpellGoal {
        CastingSpellGoal() {
            super((SpellcasterIllager)Abyssologer.this);
        }

        public void tick() {
            if (Abyssologer.this.getTarget() != null) {
                Abyssologer.this.getLookControl().setLookAt((Entity)Abyssologer.this.getTarget(), (float)Abyssologer.this.getMaxHeadYRot(), (float)Abyssologer.this.getMaxHeadXRot());
            }
        }
    }

    class SummonEyeSpellGoal
    extends SpellcasterIllager.SpellcasterUseSpellGoal {
        private final TargetingConditions eyeCountTargeting;

        SummonEyeSpellGoal() {
            super((SpellcasterIllager)Abyssologer.this);
            this.eyeCountTargeting = TargetingConditions.forNonCombat().range(16.0).ignoreLineOfSight().ignoreInvisibilityTesting();
        }

        public boolean canUse() {
            if (!super.canUse()) {
                return false;
            }
            int i = Abyssologer.this.level().getNearbyEntities(Eye.class, this.eyeCountTargeting, (LivingEntity)Abyssologer.this, Abyssologer.this.getBoundingBox().inflate(16.0)).size();
            return Abyssologer.this.random.nextInt(6) + 1 > i;
        }

        protected int getCastingTime() {
            return 60;
        }

        protected int getCastingInterval() {
            return 720;
        }

        protected void performSpellCasting() {
            ServerLevel serverlevel = (ServerLevel)Abyssologer.this.level();
            for (int i = 0; i < 3; ++i) {
                BlockPos blockpos = Abyssologer.this.blockPosition().offset(-2 + Abyssologer.this.random.nextInt(5), 1, -2 + Abyssologer.this.random.nextInt(5));
                Eye eye = (Eye)((EntityType)EntityInit.EYE.get()).create(Abyssologer.this.level());
                eye.moveTo(blockpos, 0.0f, 0.0f);
                eye.finalizeSpawn((ServerLevelAccessor)serverlevel, Abyssologer.this.level().getCurrentDifficultyAt(blockpos), MobSpawnType.MOB_SUMMONED, null);
                eye.setOwner((Mob)Abyssologer.this);
                eye.setLimitedLife(20 * (30 + Abyssologer.this.random.nextInt(90)));
                serverlevel.addFreshEntityWithPassengers((Entity)eye);
            }
        }

        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.EVOKER_PREPARE_SUMMON;
        }

        protected SpellcasterIllager.IllagerSpell getSpell() {
            return SpellcasterIllager.IllagerSpell.SUMMON_VEX;
        }
    }

    class SummonSkeletonSpellGoal
    extends SpellcasterIllager.SpellcasterUseSpellGoal {
        private final TargetingConditions eyeCountTargeting;

        SummonSkeletonSpellGoal() {
            super((SpellcasterIllager)Abyssologer.this);
            this.eyeCountTargeting = TargetingConditions.forNonCombat().range(16.0).ignoreLineOfSight().ignoreInvisibilityTesting();
        }

        public boolean canUse() {
            if (!super.canUse()) {
                return false;
            }
            int i = Abyssologer.this.level().getNearbyEntities(SpectralSkeleton.class, this.eyeCountTargeting, (LivingEntity)Abyssologer.this, Abyssologer.this.getBoundingBox().inflate(16.0)).size();
            return Abyssologer.this.random.nextInt(5) + 1 > i;
        }

        protected int getCastingTime() {
            return 60;
        }

        protected int getCastingInterval() {
            return 560;
        }

        protected void performSpellCasting() {
            ServerLevel serverlevel = (ServerLevel)Abyssologer.this.level();
            for (int i = 0; i < 2; ++i) {
                BlockPos blockpos = Abyssologer.this.blockPosition().offset(-2 + Abyssologer.this.random.nextInt(5), 1, -2 + Abyssologer.this.random.nextInt(5));
                SpectralSkeleton skeleton = (SpectralSkeleton)((EntityType)EntityInit.SPECTRAL_SKELETON.get()).create(Abyssologer.this.level());
                skeleton.moveTo(blockpos, 0.0f, 0.0f);
                skeleton.finalizeSpawn((ServerLevelAccessor)serverlevel, Abyssologer.this.level().getCurrentDifficultyAt(blockpos), MobSpawnType.MOB_SUMMONED, null);
                skeleton.setOwner((Mob)Abyssologer.this);
                skeleton.setLimitedLife(20 * (30 + Abyssologer.this.random.nextInt(90)));
                serverlevel.addFreshEntityWithPassengers((Entity)skeleton);
            }
        }

        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.EVOKER_PREPARE_SUMMON;
        }

        protected SpellcasterIllager.IllagerSpell getSpell() {
            return SpellcasterIllager.IllagerSpell.SUMMON_VEX;
        }
    }

    class BlindnessSpellGoal
    extends SpellcasterIllager.SpellcasterUseSpellGoal {
        BlindnessSpellGoal() {
            super((SpellcasterIllager)Abyssologer.this);
        }

        public boolean canUse() {
            if (!super.canUse()) {
                return false;
            }
            return (Boolean)CommonConfig.do_abyssologer_darkness.get() != false && !Abyssologer.this.getTarget().hasEffect(MobEffects.DARKNESS);
        }

        protected int getCastingTime() {
            return 35;
        }

        protected int getCastingInterval() {
            return 720;
        }

        protected void performSpellCasting() {
            Abyssologer.this.getTarget().addEffect(new MobEffectInstance(MobEffects.DARKNESS, 700));
        }

        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.EVOKER_PREPARE_ATTACK;
        }

        protected SpellcasterIllager.IllagerSpell getSpell() {
            return SpellcasterIllager.IllagerSpell.BLINDNESS;
        }
    }

    class SpikeSpellGoal
    extends SpellcasterIllager.SpellcasterUseSpellGoal {
        SpikeSpellGoal() {
            super((SpellcasterIllager)Abyssologer.this);
        }

        public boolean canUse() {
            if (!Abyssologer.this.isAlive()) {
                return false;
            }
            return super.canUse();
        }

        protected int getCastingTime() {
            return 40;
        }

        protected int getCastingInterval() {
            return 60;
        }

        protected void performSpellCasting() {
            LivingEntity livingentity = Abyssologer.this.getTarget();
            double d0 = Math.min(livingentity.getY(), Abyssologer.this.getY());
            double d1 = Math.max(livingentity.getY(), Abyssologer.this.getY()) + 1.0;
            float f = (float)Mth.atan2((double)(livingentity.getZ() - Abyssologer.this.getZ()), (double)(livingentity.getX() - Abyssologer.this.getX()));
            if (Abyssologer.this.distanceToSqr((Entity)livingentity) < 16.0 || Abyssologer.this.distanceToSqr((Entity)livingentity) < 30.0 && Abyssologer.this.getRandom().nextBoolean()) {
                float f1;
                for (int i = 0; i < 5; ++i) {
                    f1 = f + (float)i * (float)Math.PI * 0.4f;
                    this.createSpellEntity(Abyssologer.this.getX() + (double)Mth.cos((float)f1) * 1.5, Abyssologer.this.getZ() + (double)Mth.sin((float)f1) * 1.5, d0, d1, f1, 1);
                }
                for (int j = 0; j < 10; ++j) {
                    f1 = f + (float)j * (float)Math.PI * 2.0f / 10.0f + 1.2566371f;
                    this.createSpellEntity(Abyssologer.this.getX() + (double)Mth.cos((float)f1) * 3.0, Abyssologer.this.getZ() + (double)Mth.sin((float)f1) * 3.0, d0, d1, f1, 2);
                }
                for (int k = 0; k < 15; ++k) {
                    float f2 = f + (float)k * (float)Math.PI * 2.0f / 15.0f + 2.256637f;
                    this.createSpellEntity(Abyssologer.this.getX() + (double)Mth.cos((float)f2) * 4.5, Abyssologer.this.getZ() + (double)Mth.sin((float)f2) * 4.5, d0, d1, f2, 3);
                }
            } else {
                int randomPattern = new Random().nextInt(4) + 1;
                switch (randomPattern) {
                    case 1: {
                        for (int l = 0; l < 16; ++l) {
                            double d2 = 1.25 * (double)(l + 1);
                            int j = 1 * l;
                            this.createSpellEntity(Abyssologer.this.getX() + (double)Mth.cos((float)f) * d2 + ((double)new Random().nextFloat() - 0.5), Abyssologer.this.getZ() + (double)Mth.sin((float)f) * d2 + ((double)new Random().nextFloat() - 0.5), d0, d1, f, j);
                        }
                        break;
                    }
                    case 2: {
                        float f1;
                        this.createSpellEntity(Abyssologer.this.getTarget().getX(), Abyssologer.this.getTarget().getZ(), d0, d1, 0.0f, 0);
                        for (int i = 0; i < 5; ++i) {
                            f1 = f + (float)i * (float)Math.PI * 0.4f;
                            this.createSpellEntity(Abyssologer.this.getTarget().getX() + (double)Mth.cos((float)f1) * 1.0, Abyssologer.this.getTarget().getZ() + (double)Mth.sin((float)f1) * 1.0, d0, d1, f1, 1);
                        }
                        for (int j = 0; j < 8; ++j) {
                            f1 = f + (float)j * (float)Math.PI * 2.0f / 8.0f + 1.2566371f;
                            this.createSpellEntity(Abyssologer.this.getTarget().getX() + (double)Mth.cos((float)f1) * 1.5, Abyssologer.this.getTarget().getZ() + (double)Mth.sin((float)f1) * 1.5, d0, d1, f1, 2);
                        }
                        for (int k = 0; k < 25; ++k) {
                            float f2 = f + (float)k * (float)Math.PI * 2.0f / 25.0f + 2.566371f;
                            this.createSpellEntity(Abyssologer.this.getTarget().getX() + (double)Mth.cos((float)f2) * 5.0, Abyssologer.this.getTarget().getZ() + (double)Mth.sin((float)f2) * 5.0, d0, d1, f2, 3);
                        }
                        break;
                    }
                    case 3: {
                        this.createSpellEntity(Abyssologer.this.getTarget().getX(), Abyssologer.this.getTarget().getZ(), d0, d1, 0.0f, 0);
                        for (int i = 0; i < 4; ++i) {
                            float f1 = f + (float)i * (float)Math.PI * 2.0f / 4.0f;
                            this.createSpellEntity(Abyssologer.this.getTarget().getX() + (double)Mth.cos((float)f1) * 0.75, Abyssologer.this.getTarget().getZ() + (double)Mth.sin((float)f1) * 0.75, d0, d1, f1, 1);
                        }
                        for (int k = 0; k < 20; ++k) {
                            float f2 = f + (float)k * (float)Math.PI * 2.0f / 20.0f + 2.566371f;
                            this.createSpellEntity(Abyssologer.this.getTarget().getX() + (double)Mth.cos((float)f2) * 4.0, Abyssologer.this.getTarget().getZ() + (double)Mth.sin((float)f2) * 4.0, d0, d1, f2, 3);
                        }
                        break;
                    }
                    case 4: {
                        float f1;
                        this.createSpellEntity(Abyssologer.this.getTarget().getX(), Abyssologer.this.getTarget().getZ(), d0, d1, 0.0f, 0);
                        for (int i = 0; i < 4; ++i) {
                            f1 = f + (float)i * (float)Math.PI * 2.0f / 4.0f;
                            this.createSpellEntity(Abyssologer.this.getTarget().getX() + (double)Mth.cos((float)f1) * 0.75, Abyssologer.this.getTarget().getZ() + (double)Mth.sin((float)f1) * 0.75, d0, d1, f1, 1);
                        }
                        for (int j = 0; j < 7; ++j) {
                            f1 = f + (float)j * (float)Math.PI * 2.0f / 7.0f + 1.2566371f;
                            this.createSpellEntity(Abyssologer.this.getTarget().getX() + (double)Mth.cos((float)f1) * 1.25, Abyssologer.this.getTarget().getZ() + (double)Mth.sin((float)f1) * 1.25, d0, d1, f1, 2);
                        }
                        break;
                    }
                }
            }
        }

        private void createSpellEntity(double p_32673_, double p_32674_, double p_32675_, double p_32676_, float p_32677_, int p_32678_) {
            BlockPos blockpos = new BlockPos(new Vec3i((int)p_32673_, (int)p_32676_, (int)p_32674_));
            boolean flag = false;
            double d0 = 0.0;
            do {
                BlockState blockstate1;
                VoxelShape voxelshape;
                BlockPos blockpos1 = blockpos.below();
                BlockState blockstate = Abyssologer.this.level().getBlockState(blockpos1);
                if (!blockstate.isFaceSturdy((BlockGetter)Abyssologer.this.level(), blockpos1, Direction.UP)) continue;
                if (!Abyssologer.this.level().isEmptyBlock(blockpos) && !(voxelshape = (blockstate1 = Abyssologer.this.level().getBlockState(blockpos)).getCollisionShape((BlockGetter)Abyssologer.this.level(), blockpos)).isEmpty()) {
                    d0 = voxelshape.max(Direction.Axis.Y);
                }
                flag = true;
                break;
            } while ((blockpos = blockpos.below()).getY() >= Mth.floor((double)p_32675_) - 1);
            if (flag) {
                Abyssologer.this.level().addFreshEntity((Entity)new SpikeCountdown(Abyssologer.this.level(), 4.0f, p_32673_, (double)blockpos.getY() + d0, p_32674_, p_32677_, p_32678_, (LivingEntity)Abyssologer.this, 25));
            }
        }

        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.EVOKER_PREPARE_ATTACK;
        }

        protected SpellcasterIllager.IllagerSpell getSpell() {
            return SpellcasterIllager.IllagerSpell.FANGS;
        }
    }

    class FireballSpellGoal
    extends SpellcasterIllager.SpellcasterUseSpellGoal {
        FireballSpellGoal() {
            super((SpellcasterIllager)Abyssologer.this);
        }

        protected int getCastingTime() {
            return 20;
        }

        protected int getCastingInterval() {
            return 25;
        }

        protected void performSpellCasting() {
            Vec3 pos = Abyssologer.this.position();
            Vec3 posO = new Vec3(pos.x, pos.y + 2.5, pos.z);
            Vec3 pos1 = Abyssologer.this.getTarget().position();
            Vec3 posT = new Vec3(pos1.x, Abyssologer.this.getTarget().getY(0.5), pos1.z);
            double d0 = Math.sqrt((posT.x - posO.x) * (posT.x - posO.x) + (posT.y - posO.y) * (posT.y - posO.y) + (posT.z - posO.z) * (posT.z - posO.z));
            Vec3 aim = new Vec3((posT.x - posO.x) / d0, (posT.y - posO.y) / d0, (posT.z - posO.z) / d0);
            this.launchFireball(posO, aim, 4.0f);
        }

        private void launchFireball(Vec3 pos, Vec3 aim, float damage) {
            PurpleFireball fireball = new PurpleFireball((EntityType<? extends AbstractHurtingProjectile>)((EntityType)EntityInit.PURPLE_FIREBALL.get()), pos.x(), pos.y(), pos.z(), aim.x() * 0.5, aim.y() * 0.5, aim.z() * 0.5, Abyssologer.this.level(), (LivingEntity)Abyssologer.this, damage);
            Abyssologer.this.level().addFreshEntity((Entity)fireball);
            Abyssologer.this.playSound(SoundEvents.PORTAL_TRAVEL, 0.5f, 0.75f);
        }

        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.EVOKER_PREPARE_ATTACK;
        }

        protected SpellcasterIllager.IllagerSpell getSpell() {
            return SpellcasterIllager.IllagerSpell.WOLOLO;
        }
    }
}

