/*
 * Decompiled with CFR 0.152.
 */
package github.nitespring.monsterplus.common.entity;

import github.nitespring.monsterplus.common.entity.MotherLavaSquid;
import github.nitespring.monsterplus.config.CommonConfig;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.SmallFireball;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class LavaSquid
extends Monster {
    public float xBodyRot;
    public float xBodyRotO;
    public float zBodyRot;
    public float zBodyRotO;
    public float tentacleMovement;
    public float oldTentacleMovement;
    public float tentacleAngle;
    public float oldTentacleAngle;
    private float speed;
    private float tentacleSpeed;
    private float rotateSpeed;
    public float tx;
    public float ty;
    public float tz;

    public LavaSquid(EntityType<? extends Monster> p_33002_, Level p_33003_) {
        super(p_33002_, p_33003_);
        this.random.setSeed((long)this.getId());
        this.tentacleSpeed = 1.0f / (this.random.nextFloat() + 1.0f) * 0.2f;
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 16.0).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.ATTACK_DAMAGE, 2.0).add(Attributes.ATTACK_SPEED, 1.2).add(Attributes.ATTACK_KNOCKBACK, 0.2).add(Attributes.KNOCKBACK_RESISTANCE, 0.0).add(Attributes.FOLLOW_RANGE, 50.0).add(Attributes.FALL_DAMAGE_MULTIPLIER, 0.0);
    }

    protected boolean shouldDespawnInPeaceful() {
        return this.isAggressive();
    }

    public boolean isPreventingPlayerRest(Player pPlayer) {
        return this.isAggressive();
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor server, DifficultyInstance difficulty, MobSpawnType type, SpawnGroupData group) {
        Vec3 pos = this.position();
        Vec3 deltaPos = new Vec3(0.0, 5.0, 0.0);
        this.setPos(pos.add(deltaPos));
        return super.finalizeSpawn(server, difficulty, type, group);
    }

    public boolean checkSpawnObstruction(LevelReader p_21433_) {
        return p_21433_.isUnobstructed((Entity)this);
    }

    protected void spawnInk() {
        this.makeSound(this.getSquirtSound());
        Vec3 vec3 = this.rotateVector(new Vec3(0.0, -1.0, 0.0)).add(this.getX(), this.getY(), this.getZ());
        for (int i = 0; i < 30; ++i) {
            Vec3 vec31 = this.rotateVector(new Vec3((double)this.random.nextFloat() * 0.6 - 0.3, -1.0, (double)this.random.nextFloat() * 0.6 - 0.3));
            Vec3 vec32 = vec31.scale(0.3 + (double)(this.random.nextFloat() * 2.0f));
            ((ServerLevel)this.level()).sendParticles(this.getInkParticle(), vec3.x, vec3.y + 0.5, vec3.z, 0, vec32.x, vec32.y, vec32.z, (double)0.1f);
        }
    }

    public boolean hurt(DamageSource pSource, float pAmount) {
        if (super.hurt(pSource, pAmount) && this.getLastHurtByMob() != null) {
            if (!this.level().isClientSide) {
                this.spawnInk();
            }
            return true;
        }
        return false;
    }

    public void tick() {
        super.tick();
        this.doParticles();
    }

    public void doParticles() {
        if (this.tickCount % 5 == 0) {
            double x = this.getRandomX(0.6);
            double y = this.getRandomY() - 0.2;
            double z = this.getRandomZ(0.6);
            this.level().addParticle((ParticleOptions)ParticleTypes.SMALL_FLAME, x, y, z, 0.01 * ((double)this.getRandom().nextFloat() - 0.5), 0.0, 0.01 * ((double)this.getRandom().nextFloat() - 0.5));
        }
    }

    protected ParticleOptions getInkParticle() {
        return ParticleTypes.LARGE_SMOKE;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new LavaSquidAttackGoal(this));
        this.goalSelector.addGoal(3, (Goal)new SquidRandomMovementGoal(this, this));
        this.goalSelector.addGoal(2, (Goal)new SquidFleeGoal());
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
    }

    protected SoundEvent getSquirtSound() {
        return SoundEvents.SQUID_SQUIRT;
    }

    public static boolean checkLavaSquidSpawnRules(EntityType<LavaSquid> p_218985_, ServerLevelAccessor p_218986_, MobSpawnType p_218987_, BlockPos p_218988_, RandomSource p_218989_) {
        return LavaSquid.checkMobSpawnRules(p_218985_, (LevelAccessor)p_218986_, (MobSpawnType)p_218987_, (BlockPos)p_218988_, (RandomSource)p_218989_) && (Boolean)CommonConfig.spawn_lava_squid.get() != false;
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.SQUID_AMBIENT;
    }

    protected SoundEvent getHurtSound(DamageSource p_29980_) {
        return SoundEvents.SQUID_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.SQUID_DEATH;
    }

    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.EVENTS;
    }

    public boolean fireImmune() {
        return true;
    }

    public void aiStep() {
        super.aiStep();
        this.xBodyRotO = this.xBodyRot;
        this.zBodyRotO = this.zBodyRot;
        this.oldTentacleMovement = this.tentacleMovement;
        this.oldTentacleAngle = this.tentacleAngle;
        this.tentacleMovement += this.tentacleSpeed;
        if ((double)this.tentacleMovement > Math.PI * 2) {
            if (this.level().isClientSide) {
                this.tentacleMovement = (float)Math.PI * 2;
            } else {
                this.tentacleMovement -= (float)Math.PI * 2;
                if (this.random.nextInt(10) == 0) {
                    this.tentacleSpeed = 1.0f / (this.random.nextFloat() + 1.0f) * 0.2f;
                }
                this.level().broadcastEntityEvent((Entity)this, (byte)19);
            }
        }
        if (this.tentacleMovement < (float)Math.PI) {
            float f = this.tentacleMovement / (float)Math.PI;
            this.tentacleAngle = Mth.sin((float)(f * f * (float)Math.PI)) * (float)Math.PI * 0.25f;
            if ((double)f > 0.75) {
                this.speed = 1.0f;
                this.rotateSpeed = 1.0f;
            } else {
                this.rotateSpeed *= 0.8f;
            }
        } else {
            this.tentacleAngle = 0.0f;
            this.speed *= 0.9f;
            this.rotateSpeed *= 0.99f;
        }
        if (!this.level().isClientSide) {
            this.setDeltaMovement(this.tx * this.speed, this.ty * this.speed, this.tz * this.speed);
        }
        Vec3 vec3 = this.getDeltaMovement();
        double d0 = vec3.horizontalDistance();
        this.yBodyRot += (-((float)Mth.atan2((double)vec3.x, (double)vec3.z)) * 57.295776f - this.yBodyRot) * 0.1f;
        this.setYRot(this.yBodyRot);
        this.zBodyRot += (float)Math.PI * this.rotateSpeed * 1.5f;
        this.xBodyRot += (-((float)Mth.atan2((double)d0, (double)vec3.y)) * 57.295776f - this.xBodyRot) * 0.1f;
    }

    private Vec3 rotateVector(Vec3 p_29986_) {
        Vec3 vec3 = p_29986_.xRot(this.xBodyRotO * ((float)Math.PI / 180));
        return vec3.yRot(-this.yBodyRotO * ((float)Math.PI / 180));
    }

    public void travel(Vec3 p_29984_) {
        this.move(MoverType.SELF, this.getDeltaMovement());
    }

    public void handleEntityEvent(byte p_29957_) {
        if (p_29957_ == 19) {
            this.tentacleMovement = 0.0f;
        } else {
            super.handleEntityEvent(p_29957_);
        }
    }

    public void setMovementVector(float p_29959_, float p_29960_, float p_29961_) {
        this.tx = p_29959_;
        this.ty = p_29960_;
        this.tz = p_29961_;
    }

    public boolean hasMovementVector() {
        return this.tx != 0.0f || this.ty != 0.0f || this.tz != 0.0f;
    }

    public boolean isAlliedTo(Entity e) {
        if (e == null) {
            return false;
        }
        if (e == this) {
            return true;
        }
        if (super.isAlliedTo(e)) {
            return true;
        }
        return e instanceof LavaSquid || e instanceof MotherLavaSquid;
    }

    static class LavaSquidAttackGoal
    extends Goal {
        private final LavaSquid squid;
        private int attackStep;
        private int attackTime;
        private int lastSeen;

        public LavaSquidAttackGoal(LavaSquid p_32247_) {
            this.squid = p_32247_;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            LivingEntity livingentity = this.squid.getTarget();
            return livingentity != null && livingentity.isAlive() && this.squid.canAttack(livingentity);
        }

        public void start() {
            this.attackStep = 0;
        }

        public void stop() {
            this.lastSeen = 0;
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public void tick() {
            --this.attackTime;
            LivingEntity livingentity = this.squid.getTarget();
            if (livingentity != null) {
                boolean flag = this.squid.getSensing().hasLineOfSight((Entity)livingentity);
                this.lastSeen = flag ? 0 : ++this.lastSeen;
                double d0 = this.squid.distanceToSqr((Entity)livingentity);
                if (d0 < 4.0) {
                    if (!flag) {
                        return;
                    }
                    if (this.attackTime <= 0) {
                        this.attackTime = 20;
                        this.squid.doHurtTarget((Entity)livingentity);
                    }
                    this.squid.getMoveControl().setWantedPosition(livingentity.getX(), livingentity.getY(), livingentity.getZ(), 1.0);
                } else if (d0 < this.getFollowDistance() * this.getFollowDistance() && flag) {
                    double d1 = livingentity.getX() - this.squid.getX();
                    double d2 = livingentity.getY(0.5) - this.squid.getY(0.5);
                    double d3 = livingentity.getZ() - this.squid.getZ();
                    if (this.attackTime <= 0) {
                        ++this.attackStep;
                        if (this.attackStep == 1) {
                            this.attackTime = 60;
                        } else if (this.attackStep <= this.squid.getRandom().nextInt(4) + 1) {
                            this.attackTime = 6;
                        } else {
                            this.attackTime = 100;
                            this.attackStep = 0;
                        }
                        if (this.attackStep > 1) {
                            double d4 = Math.sqrt(Math.sqrt(d0)) * 0.5;
                            if (!this.squid.isSilent()) {
                                this.squid.level().levelEvent((Player)null, 1018, this.squid.blockPosition(), 0);
                            }
                            for (int i = 0; i < 1; ++i) {
                                SmallFireball smallfireball = new SmallFireball(this.squid.level(), (LivingEntity)this.squid, new Vec3(this.squid.getRandom().triangle(d1, 2.297 * d4), d2, this.squid.getRandom().triangle(d3, 2.297 * d4)));
                                double rn = (this.squid.getRandom().nextInt(10) + 1) / 6;
                                smallfireball.setPos(this.squid.getX() + Math.cos(Math.PI * 2 * rn), this.squid.getY(0.5) + 0.5 + 2.5 * Math.sin(Math.PI * 2 * rn), this.squid.getZ() + Math.sin(Math.PI * 2 * rn));
                                smallfireball.setOwner((Entity)this.squid);
                                this.squid.level().addFreshEntity((Entity)smallfireball);
                            }
                        }
                    }
                    this.squid.getLookControl().setLookAt((Entity)livingentity, 10.0f, 10.0f);
                } else if (this.lastSeen < 5) {
                    this.squid.getMoveControl().setWantedPosition(livingentity.getX(), livingentity.getY(), livingentity.getZ(), 1.0);
                }
                super.tick();
            }
        }

        private double getFollowDistance() {
            return this.squid.getAttributeValue(Attributes.FOLLOW_RANGE);
        }
    }

    class SquidRandomMovementGoal
    extends Goal {
        private final LavaSquid squid;

        public SquidRandomMovementGoal(LavaSquid this$0, LavaSquid p_30004_) {
            this.squid = p_30004_;
        }

        public boolean canUse() {
            return true;
        }

        public void tick() {
            int i = this.squid.getNoActionTime();
            if (i > 100) {
                this.squid.setMovementVector(0.0f, 0.0f, 0.0f);
            } else if (this.squid.getRandom().nextInt(SquidRandomMovementGoal.reducedTickDelay((int)50)) == 0 || !this.squid.hasMovementVector()) {
                float f = this.squid.getRandom().nextFloat() * ((float)Math.PI * 2);
                float f1 = Mth.cos((float)f) * 0.2f;
                float f2 = -0.1f + this.squid.getRandom().nextFloat() * 0.2f;
                float f3 = Mth.sin((float)f) * 0.2f;
                this.squid.setMovementVector(f1, f2, f3);
            }
        }
    }

    class SquidFleeGoal
    extends Goal {
        private int fleeTicks;

        SquidFleeGoal() {
        }

        public boolean canUse() {
            LivingEntity livingentity = LavaSquid.this.getLastHurtByMob();
            if (livingentity != null) {
                return LavaSquid.this.distanceToSqr((Entity)livingentity) < 100.0;
            }
            return false;
        }

        public void start() {
            this.fleeTicks = 0;
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public void tick() {
            ++this.fleeTicks;
            LivingEntity livingentity = LavaSquid.this.getLastHurtByMob();
            if (livingentity != null) {
                Vec3 vec3 = new Vec3(LavaSquid.this.getX() - livingentity.getX(), LavaSquid.this.getY() - livingentity.getY(), LavaSquid.this.getZ() - livingentity.getZ());
                BlockState blockstate = LavaSquid.this.level().getBlockState(new BlockPos((int)(LavaSquid.this.getX() + vec3.x), (int)(LavaSquid.this.getY() + vec3.y), (int)(LavaSquid.this.getZ() + vec3.z)));
                if (blockstate.isAir()) {
                    double d0 = vec3.length();
                    if (d0 > 0.0) {
                        vec3.normalize();
                        double d1 = 3.0;
                        if (d0 > 5.0) {
                            d1 -= (d0 - 5.0) / 5.0;
                        }
                        if (d1 > 0.0) {
                            vec3 = vec3.scale(d1);
                        }
                    }
                    LavaSquid.this.setMovementVector((float)vec3.x / 20.0f, (float)vec3.y / 20.0f, (float)vec3.z / 20.0f);
                }
                if (this.fleeTicks % 10 == 5) {
                    LavaSquid.this.level().addParticle((ParticleOptions)ParticleTypes.SMALL_FLAME, LavaSquid.this.getX(), LavaSquid.this.getY(), LavaSquid.this.getZ(), 0.0, 0.0, 0.0);
                }
            }
        }
    }
}

