/*
 * Decompiled with CFR 0.152.
 */
package github.nitespring.monsterplus.common.entity;

import github.nitespring.monsterplus.common.entity.LavaSquid;
import github.nitespring.monsterplus.config.CommonConfig;
import github.nitespring.monsterplus.core.init.EntityInit;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.LargeFireball;
import net.minecraft.world.entity.projectile.SmallFireball;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class MotherLavaSquid
extends LavaSquid {
    int birthTick = 0;

    public MotherLavaSquid(EntityType<? extends Monster> p_33002_, Level p_33003_) {
        super(p_33002_, p_33003_);
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 36.0).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.ATTACK_DAMAGE, 5.0).add(Attributes.ATTACK_SPEED, 1.2).add(Attributes.ATTACK_KNOCKBACK, 2.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.5).add(Attributes.FOLLOW_RANGE, 40.0).add(Attributes.FALL_DAMAGE_MULTIPLIER, 0.0);
    }

    @Override
    public void doParticles() {
        if (this.tickCount % 3 == 0) {
            double x = this.getRandomX(0.6);
            double y = this.getRandomY();
            double z = this.getRandomZ(0.6);
            this.level().addParticle((ParticleOptions)ParticleTypes.FLAME, x, y, z, 0.01 * ((double)this.getRandom().nextFloat() - 0.5), 0.0, 0.01 * ((double)this.getRandom().nextFloat() - 0.5));
        }
    }

    @Override
    protected boolean shouldDespawnInPeaceful() {
        return true;
    }

    @Override
    protected void spawnInk() {
    }

    @Override
    public boolean isPreventingPlayerRest(Player pPlayer) {
        return true;
    }

    public static boolean checkMotherLavaSquidSpawnRules(EntityType<MotherLavaSquid> p_218985_, LevelAccessor p_218986_, MobSpawnType p_218987_, BlockPos p_218988_, RandomSource p_218989_) {
        return p_218986_.getDifficulty() != Difficulty.PEACEFUL && MotherLavaSquid.checkMobSpawnRules(p_218985_, (LevelAccessor)p_218986_, (MobSpawnType)p_218987_, (BlockPos)p_218988_, (RandomSource)p_218989_) && (Boolean)CommonConfig.spawn_mother_lava_squid.get() != false;
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new MotherLavaSquidAttackGoal(this));
        this.goalSelector.addGoal(3, (Goal)new LavaSquid.SquidRandomMovementGoal(this, this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]).setAlertOthers(new Class[]{LavaSquid.class}));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractGolem.class, true));
    }

    @Override
    public void aiStep() {
        super.aiStep();
        ++this.birthTick;
        if (this.birthTick >= 400) {
            this.birthTick = 0;
            LavaSquid son = new LavaSquid((EntityType<? extends Monster>)((EntityType)EntityInit.LAVA_SQUID.get()), this.level());
            son.setPos(this.position());
            this.level().addFreshEntity((Entity)son);
        }
    }

    @Override
    public boolean isAlliedTo(Entity e) {
        if (e == null) {
            return false;
        }
        if (e == this) {
            return true;
        }
        if (super.isAlliedTo(e)) {
            return true;
        }
        return e instanceof LavaSquid || e instanceof MotherLavaSquid;
    }

    static class MotherLavaSquidAttackGoal
    extends Goal {
        private final LavaSquid mob;
        private int attackStep;
        private int attackTime;
        private int lastSeen;
        private Class<?>[] toIgnoreAlert;
        private int alertOthersTick;

        public MotherLavaSquidAttackGoal(LavaSquid p_32247_) {
            this.mob = p_32247_;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            LivingEntity livingentity = this.mob.getTarget();
            return livingentity != null && livingentity.isAlive() && this.mob.canAttack(livingentity);
        }

        public void start() {
            this.attackStep = 0;
            this.alertOthers();
        }

        public void stop() {
            this.lastSeen = 0;
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public void tick() {
            --this.attackTime;
            LivingEntity target = this.mob.getTarget();
            if (target != null) {
                boolean flag = this.mob.getSensing().hasLineOfSight((Entity)target);
                this.lastSeen = flag ? 0 : ++this.lastSeen;
                double d0 = this.mob.distanceToSqr((Entity)target);
                if (d0 < 4.0) {
                    if (!flag) {
                        return;
                    }
                    if (this.attackTime <= 0) {
                        this.attackTime = 20;
                        this.mob.doHurtTarget((Entity)target);
                    }
                    this.mob.getMoveControl().setWantedPosition(target.getX(), target.getY(), target.getZ(), 1.0);
                } else if (d0 < this.getFollowDistance() * this.getFollowDistance() && flag) {
                    double d1 = target.getX() - this.mob.getX();
                    double d2 = target.getY(0.5) - this.mob.getY(0.5);
                    double d3 = target.getZ() - this.mob.getZ();
                    if (this.attackTime <= 0) {
                        Random rand = new Random();
                        int rng = rand.nextInt(10) + 1;
                        if (rng >= 8 && this.attackStep == 1) {
                            LargeFireball fireball = new LargeFireball(this.mob.level(), (LivingEntity)this.mob, new Vec3(d1 / d0, d2 / d0, d3 / d0), 2);
                            fireball.setDeltaMovement(d1 / d0, d2 / d0, d3 / d0);
                            fireball.setPos(this.mob.getX() + 3.0 * d1 / d0, this.mob.getY(0.5) + 3.0 * d2 / d0, this.mob.getZ() + 3.0 * d3 / d0);
                            fireball.setOwner((Entity)this.mob);
                            this.mob.level().addFreshEntity((Entity)fireball);
                            this.attackTime = 60;
                        } else {
                            ++this.attackStep;
                            if (this.attackStep == 1) {
                                this.attackTime = 60;
                            } else if (this.attackStep <= 13) {
                                this.attackTime = 6;
                            } else {
                                this.attackTime = 100;
                                this.attackStep = 0;
                            }
                        }
                        if (this.attackStep > 1) {
                            if (!this.mob.isSilent()) {
                                this.mob.level().levelEvent((Player)null, 1018, this.mob.blockPosition(), 0);
                            }
                            Vec3 pos = this.mob.position().add(0.0, (double)(0.5f + this.mob.getBbHeight() / 2.0f), 0.0);
                            Vec3 pos1 = this.mob.getTarget().position().add(0.0, (double)(this.mob.getTarget().getBbHeight() / 2.0f), 0.0);
                            Vec3 aim = pos1.add(pos.scale(-1.0)).normalize();
                            Vec3 pos2 = pos.add(aim.scale(3.5));
                            Double a = -0.5235987755982988;
                            for (int i = 0; i <= 1; ++i) {
                                Double b = (double)(this.attackStep - 1) * a;
                                Double d = 3.5;
                                Random r = new Random();
                                Vec3 aim1 = new Vec3(aim.z, -aim.y, aim.x);
                                Vec3 aim2 = new Vec3(aim.x * Math.cos(b) - aim.z * Math.sin(b), aim.y, aim.z * Math.cos(b) + aim.x * Math.sin(b));
                                double e = Math.sqrt(aim.x * aim.x + aim.z * aim.z);
                                Vec3 pos3 = new Vec3(pos2.x + d * (aim1.x * Math.cos(b) - aim.y * Math.sin(b)), pos2.y + d * (aim.y * Math.cos(b) + e * Math.sin(b)), pos2.z + d * (aim1.z * Math.cos(b) - aim.y * Math.sin(b)));
                                if (i == 1) {
                                    b = (double)(this.attackStep - 1) * a + Math.PI;
                                    pos3 = new Vec3(pos2.x + d * (aim1.x * Math.cos(b) - aim.y * Math.sin(b)), pos2.y + d * (aim.y * Math.cos(b) + e * Math.sin(b)), pos2.z + d * (aim1.z * Math.cos(b) - aim.y * Math.sin(b)));
                                }
                                Vec3 pos4 = pos1.add((double)(2.5f * (r.nextFloat() - 0.5f)), (double)(2.5f * (r.nextFloat() - 0.5f)), (double)(2.5f * (r.nextFloat() - 0.5f)));
                                Vec3 aim3 = pos4.add(pos3.scale(-1.0)).normalize();
                                Vec3 mov = aim3.scale((double)0.1f);
                                SmallFireball smallfireball = new SmallFireball(this.mob.level(), (LivingEntity)this.mob, mov);
                                smallfireball.setOwner((Entity)this.mob);
                                smallfireball.setDeltaMovement(mov);
                                smallfireball.setPos(pos3);
                                this.mob.level().addFreshEntity((Entity)smallfireball);
                            }
                        }
                    }
                    this.mob.getLookControl().setLookAt((Entity)target, 10.0f, 10.0f);
                } else if (this.lastSeen < 5) {
                    this.mob.getMoveControl().setWantedPosition(target.getX(), target.getY(), target.getZ(), 1.0);
                }
                super.tick();
            }
            ++this.alertOthersTick;
            if (this.alertOthersTick >= 600) {
                this.alertOthers();
            }
        }

        protected void alertOthers() {
            double d0 = 100.0;
            AABB aabb = AABB.unitCubeFromLowerCorner((Vec3)this.mob.position()).inflate(d0, 10.0, d0);
            List list = this.mob.level().getEntitiesOfClass(LavaSquid.class, aabb, EntitySelector.NO_SPECTATORS);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Mob mob = (Mob)iterator.next();
                if (this.mob == mob || mob.getTarget() != null) continue;
                if (this.toIgnoreAlert != null) {
                    boolean flag = false;
                    for (Class<?> oclass : this.toIgnoreAlert) {
                        if (mob.getClass() != oclass) continue;
                        flag = true;
                        break;
                    }
                    if (flag) continue;
                }
                this.alertOther(mob, this.mob.getLastHurtByMob());
            }
            return;
        }

        protected void alertOther(Mob p_26042_, LivingEntity p_26043_) {
            p_26042_.setTarget(p_26043_);
        }

        private double getFollowDistance() {
            return this.mob.getAttributeValue(Attributes.FOLLOW_RANGE);
        }
    }
}

