/*
 * Decompiled with CFR 0.152.
 */
package github.nitespring.monsterplus.common.entity;

import github.nitespring.monsterplus.common.entity.Wisp;
import github.nitespring.monsterplus.common.entity.projectiles.SoulflameFireball;
import github.nitespring.monsterplus.config.CommonConfig;
import github.nitespring.monsterplus.core.init.EntityInit;
import github.nitespring.monsterplus.core.init.ParticleInit;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;

public class Soul
extends Wisp {
    public Soul(EntityType<? extends Monster> p_33002_, Level p_33003_) {
        super(p_33002_, p_33003_);
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new SoulAttackGoal(this));
        this.goalSelector.addGoal(3, (Goal)new Wisp.SquidRandomMovementGoal(this, this));
        this.goalSelector.addGoal(2, (Goal)new Wisp.SquidFleeGoal(this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
    }

    @Override
    public void doParticles() {
        if (this.tickCount % 3 == 0) {
            double x = this.getRandomX(0.6);
            double y = this.getRandomY() - 0.2;
            double z = this.getRandomZ(0.6);
            this.level().addParticle((ParticleOptions)ParticleInit.SMALL_SOULFLAME.get(), x, y, z, 0.01 * ((double)this.getRandom().nextFloat() - 0.5), 0.0, 0.01 * ((double)this.getRandom().nextFloat() - 0.5));
        }
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 12.0).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.ATTACK_DAMAGE, 3.0).add(Attributes.ATTACK_SPEED, 1.2).add(Attributes.ATTACK_KNOCKBACK, 0.2).add(Attributes.KNOCKBACK_RESISTANCE, 0.0).add(Attributes.FOLLOW_RANGE, 30.0).add(Attributes.FALL_DAMAGE_MULTIPLIER, 0.0);
    }

    public static boolean checkSoulSpawnRules(EntityType<Soul> p_218985_, ServerLevelAccessor p_218986_, MobSpawnType p_218987_, BlockPos p_218988_, RandomSource p_218989_) {
        return Soul.checkMobSpawnRules(p_218985_, (LevelAccessor)p_218986_, (MobSpawnType)p_218987_, (BlockPos)p_218988_, (RandomSource)p_218989_) && (Boolean)CommonConfig.spawn_wisp.get() != false;
    }

    @Override
    protected ParticleOptions getInkParticle() {
        return (ParticleOptions)ParticleInit.SMALL_SOULFLAME.get();
    }

    static class SoulAttackGoal
    extends Goal {
        private final Wisp squid;
        private int attackStep;
        private int attackTime;
        private int lastSeen;

        public SoulAttackGoal(Wisp p_32247_) {
            this.squid = p_32247_;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            LivingEntity livingentity = this.squid.getTarget();
            return livingentity != null && livingentity.isAlive() && this.squid.canAttack(livingentity);
        }

        public void start() {
            this.attackStep = 0;
        }

        public void stop() {
            this.lastSeen = 0;
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public void tick() {
            --this.attackTime;
            LivingEntity livingentity = this.squid.getTarget();
            if (livingentity != null) {
                boolean flag = this.squid.getSensing().hasLineOfSight((Entity)livingentity);
                this.lastSeen = flag ? 0 : ++this.lastSeen;
                double d0 = this.squid.distanceToSqr((Entity)livingentity);
                if (d0 < 4.0) {
                    if (!flag) {
                        return;
                    }
                    if (this.attackTime <= 0) {
                        this.attackTime = 20;
                        this.squid.doHurtTarget((Entity)livingentity);
                    }
                    this.squid.getMoveControl().setWantedPosition(livingentity.getX(), livingentity.getY(), livingentity.getZ(), 1.0);
                } else if (d0 < this.getFollowDistance() * this.getFollowDistance() && flag) {
                    double d1 = livingentity.getX() - this.squid.getX();
                    double d2 = livingentity.getY(0.5) - this.squid.getY(0.5);
                    double d3 = livingentity.getZ() - this.squid.getZ();
                    if (this.attackTime <= 0) {
                        ++this.attackStep;
                        if (this.attackStep == 1) {
                            this.attackTime = 60;
                        } else if (this.attackStep <= this.squid.getRandom().nextInt(4) + 1) {
                            this.attackTime = 6;
                        } else {
                            this.attackTime = 100;
                            this.attackStep = 0;
                        }
                        if (this.attackStep > 1) {
                            double d4 = Math.sqrt(Math.sqrt(d0)) * 0.5;
                            if (!this.squid.isSilent()) {
                                this.squid.level().levelEvent((Player)null, 1018, this.squid.blockPosition(), 0);
                            }
                            for (int i = 0; i < 1; ++i) {
                                SoulflameFireball smallfireball = new SoulflameFireball((EntityType<? extends AbstractHurtingProjectile>)((EntityType)EntityInit.SOULFLAME_FIREBALL.get()), (LivingEntity)this.squid, new Vec3(this.squid.getRandom().triangle(d1, 2.297 * d4), d2, this.squid.getRandom().triangle(d3, 2.297 * d4)), this.squid.level());
                                double rn = (this.squid.getRandom().nextInt(10) + 1) / 6;
                                smallfireball.setPos(this.squid.getX() + Math.cos(Math.PI * 2 * rn), this.squid.getY(0.5) + 0.5 + 2.5 * Math.sin(Math.PI * 2 * rn), this.squid.getZ() + Math.sin(Math.PI * 2 * rn));
                                smallfireball.setOwner((Entity)this.squid);
                                this.squid.level().addFreshEntity((Entity)smallfireball);
                            }
                        }
                    }
                    this.squid.getLookControl().setLookAt((Entity)livingentity, 10.0f, 10.0f);
                } else if (this.lastSeen < 5) {
                    this.squid.getMoveControl().setWantedPosition(livingentity.getX(), livingentity.getY(), livingentity.getZ(), 1.0);
                }
                super.tick();
            }
        }

        private double getFollowDistance() {
            return this.squid.getAttributeValue(Attributes.FOLLOW_RANGE);
        }
    }
}

