/*
 * Decompiled with CFR 0.152.
 */
package github.nitespring.monsterplus.common.entity.projectiles;

import github.nitespring.monsterplus.common.entity.projectiles.CrystalSpikes;
import github.nitespring.monsterplus.common.item.CrystalArrowItem;
import github.nitespring.monsterplus.core.init.EntityInit;
import github.nitespring.monsterplus.core.init.ItemInit;
import java.util.Random;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class CrystalArrow
extends AbstractArrow {
    public CrystalArrow(EntityType<? extends AbstractArrow> e, Level l) {
        super(e, l);
    }

    public CrystalArrow(Level level, LivingEntity e, ItemStack stack, ItemStack stack1) {
        super((EntityType)EntityInit.CRYSTAL_ARROW.get(), e, level, stack, stack1);
    }

    protected ItemStack getPickupItem() {
        return ((CrystalArrowItem)((Object)ItemInit.CRYSTAL_ARROW.get())).getDefaultInstance();
    }

    protected ItemStack getDefaultPickupItem() {
        return ((CrystalArrowItem)((Object)ItemInit.CRYSTAL_ARROW.get())).getDefaultInstance();
    }

    protected void onHitEntity(EntityHitResult p_37259_) {
        p_37259_.getEntity().hurt(this.level().damageSources().indirectMagic(this.getOwner(), (Entity)this), 1.0f);
        this.createCrystals();
        super.onHitEntity(p_37259_);
    }

    protected void onHitBlock(BlockHitResult p_37258_) {
        this.createCrystals();
        super.onHitBlock(p_37258_);
        this.discard();
    }

    private void createCrystals() {
        Vec3 mov = this.getDeltaMovement();
        this.level().addFreshEntity((Entity)new CrystalSpikes(this.level(), 5.0f, this.position().x + 0.75 * mov.x, this.getY() - 0.5, this.position().z + 0.75 * mov.z, this.yRotO + new Random().nextFloat(), 10, (LivingEntity)this.getOwner()));
        for (int k = 0; k < 5; ++k) {
            this.level().addFreshEntity((Entity)new CrystalSpikes(this.level(), 5.0f, this.position().x + 0.25 * mov.x + 2.5 * ((double)new Random().nextFloat() - 0.5), this.getY() - 0.5, this.position().z + 0.25 * mov.z + 2.5 * ((double)new Random().nextFloat() - 0.5), this.yRotO + new Random().nextFloat(), new Random().nextInt(8), (LivingEntity)this.getOwner()));
        }
    }
}

