/*
 * Decompiled with CFR 0.152.
 */
package github.nitespring.monsterplus.common.entity.projectiles;

import github.nitespring.monsterplus.core.util.CustomBlockTags;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class Flame
extends AbstractHurtingProjectile
implements ItemSupplier {
    protected float damage;
    public int gravTick;
    public int hitBlocks;
    protected static final EntityDataAccessor<Integer> FLYING_TIME = SynchedEntityData.defineId(Flame.class, (EntityDataSerializer)EntityDataSerializers.INT);
    protected static final EntityDataAccessor<Float> SIZE = SynchedEntityData.defineId(Flame.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    protected static final EntityDataAccessor<Integer> RICOCHET = SynchedEntityData.defineId(Flame.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public Flame(EntityType<? extends AbstractHurtingProjectile> e, Level l) {
        super(e, l);
    }

    public Flame(EntityType<? extends AbstractHurtingProjectile> e, float damageIn, int flyingTime, int ricochetIn, Level l) {
        super(e, l);
        this.damage = damageIn;
        this.setRicochet(ricochetIn);
        this.setFlyingTime(flyingTime);
    }

    public float getAttackDamage() {
        return this.damage;
    }

    public void setAttackDamage(float damage) {
        this.damage = damage;
    }

    public int getFlyingTime() {
        return (Integer)this.entityData.get(FLYING_TIME);
    }

    public void setFlyingTime(int flyingTime) {
        this.entityData.set(FLYING_TIME, (Object)flyingTime);
    }

    public float getSize() {
        return ((Float)this.entityData.get(SIZE)).floatValue();
    }

    public void setSize(float size) {
        this.entityData.set(SIZE, (Object)Float.valueOf(size));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(SIZE, (Object)Float.valueOf(0.4f));
        builder.define(RICOCHET, (Object)0);
        builder.define(FLYING_TIME, (Object)60);
    }

    public int getRicochet() {
        return (Integer)this.entityData.get(RICOCHET);
    }

    public void setRicochet(int ricochet) {
        this.entityData.set(RICOCHET, (Object)ricochet);
    }

    protected void onHitEntity(EntityHitResult p_37259_) {
        Entity e = p_37259_.getEntity();
        if (!(e instanceof Flame || this.getOwner() != null && e.isAlliedTo(this.getOwner()))) {
            super.onHitEntity(p_37259_);
            e.hurt(e.level().damageSources().mobProjectile((Entity)this, (LivingEntity)this.getOwner()), this.damage);
            if (e instanceof Mob) {
                Mob mob = (Mob)e;
            }
            e.igniteForTicks(100);
        }
    }

    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
        BlockState block = this.level().getBlockState(result.getBlockPos());
        if (block.is(CustomBlockTags.FLAME_BREAKABLE)) {
            this.level().destroyBlock(result.getBlockPos(), true, this.getOwner());
            this.level().gameEvent((Entity)this, (Holder)GameEvent.BLOCK_DESTROY, result.getBlockPos());
        } else {
            ++this.hitBlocks;
            if (this.hitBlocks >= this.getRicochet()) {
                this.discard();
                if (this.getOwner() != null) {
                    this.getOwner().level().playSound((Player)null, this.position().x(), this.position().y(), this.position().z(), SoundEvents.FURNACE_FIRE_CRACKLE, SoundSource.AMBIENT, 0.1f, 1.6f);
                }
            } else {
                Vec3 mov = this.getDeltaMovement();
                Random r = new Random();
                float r1 = 2.0f * (r.nextFloat() - 0.5f);
                float r2 = 2.0f * (r.nextFloat() - 0.5f);
                float r3 = 2.0f * (r.nextFloat() - 0.5f);
                this.setDeltaMovement(-mov.x * (0.6 - 0.4 * (double)r1), -mov.y * (0.6 - 0.4 * (double)r2), -mov.z * (0.6 - 0.4 * (double)r3));
                this.getOwner().level().playSound((Player)null, this.position().x(), this.position().y(), this.position().z(), SoundEvents.ANVIL_HIT, SoundSource.AMBIENT, 0.2f, 1.6f);
                this.gravTick = 0;
            }
        }
        BlockPos blockPos = result.getBlockPos().relative(result.getDirection());
        if (this.level().getBlockState(blockPos).is(CustomBlockTags.FLAME_BREAKABLE)) {
            this.level().destroyBlock(blockPos, true, this.getOwner());
            this.level().gameEvent((Entity)this, (Holder)GameEvent.BLOCK_DESTROY, blockPos);
        }
        if (BaseFireBlock.canBePlacedAt((Level)this.level(), (BlockPos)blockPos, (Direction)result.getDirection())) {
            BlockState blockstate = BaseFireBlock.getState((BlockGetter)this.level(), (BlockPos)blockPos);
            this.level().setBlock(blockPos, blockstate, 11);
            this.level().gameEvent((Entity)this, (Holder)GameEvent.BLOCK_PLACE, blockPos);
        }
    }

    public void tick() {
        Flame.setViewScale((double)this.getSize());
        super.tick();
        ++this.gravTick;
        this.setDeltaMovement(this.getDeltaMovement().add(0.0, -1.0E-4 * Math.pow(this.gravTick, 2.0), 0.0));
        if (this.tickCount >= this.getFlyingTime()) {
            this.discard();
        }
        SimpleParticleType particle = ParticleTypes.FLAME;
        RandomSource rng = this.random;
        float width = this.getBbWidth() * 0.5f;
        float height = this.getBbHeight() * 0.5f;
        Vec3 pos = this.position();
        Level world = this.level();
        BlockPos blockPos = new BlockPos((int)pos.x, (int)pos.y, (int)pos.z);
        if (this.level().getBlockState(blockPos).is(CustomBlockTags.FLAME_BREAKABLE)) {
            this.level().destroyBlock(blockPos, true, this.getOwner());
            this.level().gameEvent((Entity)this, (Holder)GameEvent.BLOCK_DESTROY, blockPos);
            if (BaseFireBlock.canBePlacedAt((Level)this.level(), (BlockPos)blockPos, (Direction)Direction.getNearest((double)pos.x, (double)pos.y, (double)pos.z))) {
                BlockState blockstate = BaseFireBlock.getState((BlockGetter)this.level(), (BlockPos)blockPos);
                this.level().setBlock(blockPos, blockstate, 11);
                this.level().gameEvent((Entity)this, (Holder)GameEvent.BLOCK_PLACE, blockPos);
            }
        }
        for (int i = 0; i < 1; ++i) {
            Vec3 off = new Vec3(rng.nextDouble() * (double)width - (double)(width / 2.0f), rng.nextDouble() * (double)height - (double)(height / 2.0f), rng.nextDouble() * (double)width - (double)(width / 2.0f));
            if (!(world instanceof ServerLevel)) continue;
            ((ServerLevel)world).sendParticles((ParticleOptions)particle, pos.x + 0.2 * off.x, pos.y + (double)(height / 2.0f) + 0.2 + 0.2 * off.y, pos.z + 0.2 * off.z, 5, 0.1 * off.x, 0.05 * off.y + (double)0.1f, 0.1 * off.z, 0.025);
        }
    }

    public boolean isOnFire() {
        return false;
    }

    public boolean fireImmune() {
        return true;
    }

    @Nullable
    protected ParticleOptions getTrailParticle() {
        return ParticleTypes.FLAME;
    }

    public boolean canBeHitByProjectile() {
        return false;
    }

    protected boolean canHitEntity(Entity p_36842_) {
        if (p_36842_ instanceof Flame) {
            return false;
        }
        return super.canHitEntity(p_36842_);
    }

    public ItemStack getItem() {
        return Items.BLAZE_POWDER.getDefaultInstance();
    }
}

