/*
 * Decompiled with CFR 0.152.
 */
package github.nitespring.monsterplus.common.entity.projectiles;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class SkullProjectile
extends AbstractHurtingProjectile {
    @Nullable
    LivingEntity target;
    private float attackDamage = 4.0f;

    public SkullProjectile(EntityType<? extends AbstractHurtingProjectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Nullable
    public LivingEntity getTarget() {
        return this.target;
    }

    public float getAttackDamage() {
        return this.attackDamage;
    }

    public void setAttackDamage(float attackDamage) {
        this.attackDamage = attackDamage;
    }

    public void setTarget(LivingEntity mob) {
        this.target = mob;
    }

    @Nullable
    protected ParticleOptions getTrailParticle() {
        return ParticleTypes.SOUL_FIRE_FLAME;
    }

    public boolean isOnFire() {
        return false;
    }

    public void tick() {
        super.tick();
        if (this.tickCount >= 120) {
            this.discard();
        }
        Vec3 vec3 = this.getDeltaMovement();
        double d0 = vec3.horizontalDistance();
        this.setYRot((float)(Mth.atan2((double)vec3.x, (double)vec3.z) * 57.2957763671875));
        this.setXRot((float)(Mth.atan2((double)vec3.y, (double)d0) * 57.2957763671875));
        this.yRotO = this.getYRot();
        this.xRotO = this.getXRot();
        if (this.target != null) {
            Vec3 mov = this.getDeltaMovement();
            Vec3 pos = this.position();
            Vec3 pos1 = this.target.position().add(0.0, (double)this.target.getBbHeight() * 0.5 + 0.5, 0.0);
            Vec3 aim = new Vec3(pos1.x - pos.x, pos1.y - pos.y, pos1.z - pos.z).normalize().scale(mov.length());
            this.setDeltaMovement(this.getDeltaMovement().lerp(aim, (double)0.075f));
        } else {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, (double)-0.005f, 0.0));
        }
        if (this.tickCount % 6 == 0) {
            this.playSound(SoundEvents.CAMPFIRE_CRACKLE, 0.2f, 0.4f);
        }
        this.level().addParticle((ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, this.getRandomX(0.6), this.getRandomY(), this.getRandomZ(0.6), 0.0, 0.0, 0.0);
    }

    public boolean isAttackable() {
        return true;
    }

    public boolean isPickable() {
        return super.isPickable();
    }

    public boolean canBeCollidedWith() {
        return false;
    }

    public boolean canBeHitByProjectile() {
        return false;
    }

    protected void onHitBlock(BlockHitResult pResult) {
        this.playSound((SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), 0.2f, 1.2f);
        this.discard();
    }

    protected boolean canHitEntity(Entity e) {
        if (this.getOwner() != null && (e == this.getOwner() || this.getOwner().isAlliedTo(e))) {
            return false;
        }
        return super.canHitEntity(e);
    }

    protected void onHitEntity(EntityHitResult pResult) {
        pResult.getEntity().hurt(this.level().damageSources().indirectMagic(this.getOwner(), (Entity)this), this.getAttackDamage());
        this.playSound((SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), 0.2f, 1.2f);
        this.discard();
    }

    public boolean hurt(DamageSource pSource, float pAmount) {
        return false;
    }

    protected void onDeflection(@Nullable Entity pEntity, boolean pDeflectedByPlayer) {
        super.onDeflection(pEntity, pDeflectedByPlayer);
    }

    public boolean deflect(ProjectileDeflection pDeflection, @Nullable Entity pEntity, @Nullable Entity pOwner, boolean pDeflectedByPlayer) {
        Entity entity;
        if (this.getOwner() != null && (entity = this.getOwner()) instanceof LivingEntity) {
            LivingEntity owner = (LivingEntity)entity;
            this.setTarget(owner);
        } else {
            this.setTarget(null);
        }
        return super.deflect(pDeflection, pEntity, pOwner, pDeflectedByPlayer);
    }
}

