/*
 * Decompiled with CFR 0.152.
 */
package github.nitespring.monsterplus.common.item;

import github.nitespring.monsterplus.common.entity.projectiles.CrystalClump;
import github.nitespring.monsterplus.core.init.EntityInit;
import github.nitespring.monsterplus.core.init.ItemInit;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class CrystalClumpItem
extends Item {
    public CrystalClumpItem(Item.Properties properties) {
        super(properties.stacksTo(16).rarity(Rarity.RARE));
    }

    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, InteractionHand handIn) {
        if (!worldIn.isClientSide) {
            Vec3 pos = playerIn.position();
            Vec3 aim = playerIn.getLookAngle();
            CrystalClump clump = new CrystalClump((EntityType<? extends AbstractHurtingProjectile>)((EntityType)EntityInit.CRYSTAL_CLUMP.get()), worldIn);
            clump.setPos(new Vec3(pos.x + aim.x * 0.5, pos.y + 1.75 + aim.y * 0.5, pos.z + aim.z * 0.5));
            clump.setDeltaMovement(aim.add(0.0, 0.25 * aim.horizontalDistance(), 0.0).normalize().scale(0.5));
            clump.accelerationPower = 0.5;
            worldIn.addFreshEntity((Entity)clump);
            if (!playerIn.isCreative()) {
                playerIn.getItemInHand(handIn).shrink(1);
            }
            playerIn.awardStat(Stats.ITEM_USED.get((Object)this));
            playerIn.getCooldowns().addCooldown((Item)ItemInit.CRYSTAL_CLUMP.get(), 12);
        }
        return super.use(worldIn, playerIn, handIn);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        String string = "\u00a77\u00a7oSummons Crystal Spikes from the ground when thrown";
        tooltip.add((Component)Component.literal((String)string));
    }
}

