/*
 * Decompiled with CFR 0.152.
 */
package github.nitespring.monsterplus.common.item;

import github.nitespring.monsterplus.common.entity.projectiles.SpikeCountdown;
import github.nitespring.monsterplus.common.item.ILeftClickSpecialActionItem;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class Darkstar
extends SwordItem
implements ILeftClickSpecialActionItem {
    public Darkstar(Tier tier, Item.Properties p) {
        super(tier, p.attributes(SwordItem.createAttributes((Tier)Tiers.DIAMOND, (int)13, (float)-2.8f)).stacksTo(1).rarity(Rarity.EPIC));
    }

    public boolean isFoil(ItemStack i) {
        return super.isFoil(i);
    }

    @Override
    public void doLeftClickAction(Player playerIn, ItemStack item) {
        item.hurtAndBreak(1, (LivingEntity)playerIn, EquipmentSlot.MAINHAND);
        Vec3 posTarget = playerIn.position().add(playerIn.getLookAngle().scale(15.0));
        double d0 = Math.min(posTarget.y, playerIn.getY());
        double d1 = Math.max(posTarget.y, playerIn.getY()) + 1.0;
        float f = (float)Mth.atan2((double)(posTarget.z - playerIn.getZ()), (double)(posTarget.x - playerIn.getX()));
        for (int l = 0; l < 8; ++l) {
            double d2 = 1.25 * (double)(l + 1);
            int j = 1 * l;
            this.createSpellEntity(playerIn, playerIn.getX() + (double)Mth.cos((float)f) * d2 + ((double)new Random().nextFloat() - 0.5), playerIn.getZ() + (double)Mth.sin((float)f) * d2 + ((double)new Random().nextFloat() - 0.5), d0, d1, f, j);
        }
    }

    private void createSpellEntity(Player playerIn, double p_32673_, double p_32674_, double p_32675_, double p_32676_, float p_32677_, int p_32678_) {
        BlockPos blockpos = new BlockPos((int)p_32673_, (int)p_32676_, (int)p_32674_);
        boolean flag = false;
        double d0 = 0.0;
        do {
            BlockState blockstate1;
            VoxelShape voxelshape;
            BlockPos blockpos1 = blockpos.below();
            BlockState blockstate = playerIn.level().getBlockState(blockpos1);
            if (!blockstate.isFaceSturdy((BlockGetter)playerIn.level(), blockpos1, Direction.UP)) continue;
            if (!playerIn.level().isEmptyBlock(blockpos) && !(voxelshape = (blockstate1 = playerIn.level().getBlockState(blockpos)).getCollisionShape((BlockGetter)playerIn.level(), blockpos)).isEmpty()) {
                d0 = voxelshape.max(Direction.Axis.Y);
            }
            flag = true;
            break;
        } while ((blockpos = blockpos.below()).getY() >= Mth.floor((double)p_32675_) - 1);
        if (flag) {
            playerIn.level().addFreshEntity((Entity)new SpikeCountdown(playerIn.level(), 6.0f, p_32673_, (double)blockpos.getY() + d0, p_32674_, p_32677_, p_32678_, (LivingEntity)playerIn, 0));
        }
    }
}

