/*
 * Decompiled with CFR 0.152.
 */
package github.nitespring.monsterplus.core.enums;

import com.google.common.base.Suppliers;
import github.nitespring.monsterplus.core.init.ItemInit;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public enum CustomItemTiers implements Tier
{
    CRYSTAL(BlockTags.INCORRECT_FOR_DIAMOND_TOOL, 1561, 9.0f, 5.0f, 20, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemInit.CRYSTAL_SHARD.get()})),
    BONE(BlockTags.INCORRECT_FOR_IRON_TOOL, 131, 4.0f, 1.0f, 5, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.BONE}));

    private final TagKey<Block> incorrectBlocksForDrops;
    private final int uses;
    private final float speed;
    private final float damage;
    private final int enchantmentValue;
    private final Supplier<Ingredient> repairIngredient;

    private CustomItemTiers(TagKey p_334032_, int p_43332_, float p_43334_, float p_43335_, int p_43333_, Supplier<Ingredient> supplier) {
        this.incorrectBlocksForDrops = p_334032_;
        this.uses = p_43332_;
        this.speed = p_43334_;
        this.damage = p_43335_;
        this.enchantmentValue = p_43333_;
        Objects.requireNonNull(supplier);
        this.repairIngredient = Suppliers.memoize(supplier::get);
    }

    public int getUses() {
        return this.uses;
    }

    public float getSpeed() {
        return this.speed;
    }

    public float getAttackDamageBonus() {
        return this.damage;
    }

    public TagKey<Block> getIncorrectBlocksForDrops() {
        return this.incorrectBlocksForDrops;
    }

    public int getEnchantmentValue() {
        return this.enchantmentValue;
    }

    public Ingredient getRepairIngredient() {
        return this.repairIngredient.get();
    }
}

