/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.com.grack.nanojson;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigInteger;
import java.net.URL;
import org.watermedia.shaded.com.grack.nanojson.JsonArray;
import org.watermedia.shaded.com.grack.nanojson.JsonLazyNumber;
import org.watermedia.shaded.com.grack.nanojson.JsonObject;
import org.watermedia.shaded.com.grack.nanojson.JsonParserException;
import org.watermedia.shaded.com.grack.nanojson.JsonTokener;

public final class JsonParser {
    private Object value;
    private int token;
    private JsonTokener tokener;
    private boolean lazyNumbers;

    JsonParser(JsonTokener jsonTokener, boolean bl) throws JsonParserException {
        this.tokener = jsonTokener;
        this.lazyNumbers = bl;
    }

    public static JsonParserContext<JsonObject> object() {
        return new JsonParserContext<JsonObject>(JsonObject.class);
    }

    public static JsonParserContext<JsonArray> array() {
        return new JsonParserContext<JsonArray>(JsonArray.class);
    }

    public static JsonParserContext<Object> any() {
        return new JsonParserContext<Object>(Object.class);
    }

    <T> T parse(Class<T> clazz) throws JsonParserException {
        this.advanceToken(false, false);
        Object object = this.currentValue();
        if (this.advanceToken(false, false) != 0) {
            throw this.tokener.createParseException(null, "Expected end of input, got " + this.token, true);
        }
        if (!(clazz == Object.class || object != null && clazz.isAssignableFrom(object.getClass()))) {
            throw this.tokener.createParseException(null, "JSON did not contain the correct type, expected " + clazz.getSimpleName() + ".", true);
        }
        return clazz.cast(object);
    }

    private Object currentValue() throws JsonParserException {
        if (this.token >= 5) {
            return this.value;
        }
        throw this.tokener.createParseException(null, "Expected JSON value, got " + this.token, true);
    }

    /*
     * Unable to fully structure code
     */
    private int advanceToken(boolean var1_1, boolean var2_2) throws JsonParserException {
        if (var2_2) {
            --this.tokener.index;
        }
        this.token = this.tokener.advanceToToken(var1_1);
        switch (this.token) {
            case 11: {
                var3_3 = new JsonArray();
                if (this.advanceToken(false, false) == 4) ** GOTO lbl18
                do {
                    var3_3.add(this.currentValue());
                    if (this.token == 12) {
                        throw this.tokener.createParseException(null, "Semi-string is not allowed in array", true);
                    }
                    if (this.advanceToken(false, false) == 4) ** GOTO lbl18
                    if (this.token == 1) continue;
                    throw this.tokener.createParseException(null, "Expected a comma or end of the array instead of " + this.token, true);
                } while (this.advanceToken(false, false) != 4);
                throw this.tokener.createParseException(null, "Trailing comma found in array", true);
lbl18:
                // 2 sources

                this.value = var3_3;
                this.token = 11;
                return 11;
            }
            case 10: {
                var4_4 = new JsonObject();
                if (this.advanceToken(true, false) == 3) ** GOTO lbl45
                do {
                    switch (this.token) {
                        case 5: 
                        case 6: 
                        case 7: {
                            this.value = this.value.toString();
                            break;
                        }
                        case 8: 
                        case 12: {
                            break;
                        }
                        default: {
                            throw this.tokener.createParseException(null, "Expected STRING, got " + this.token, true);
                        }
                    }
                    var5_5 = (String)this.value;
                    if (this.token == 12 ? this.advanceToken(false, true) != 2 : this.advanceToken(false, false) != 2) {
                        throw this.tokener.createParseException(null, "Expected COLON, got " + this.token, true);
                    }
                    this.advanceToken(false, false);
                    var4_4.put(var5_5, this.currentValue());
                    if (this.advanceToken(false, false) == 3) ** GOTO lbl45
                    if (this.token == 1) continue;
                    throw this.tokener.createParseException(null, "Expected a comma or end of the object instead of " + this.token, true);
                } while (this.advanceToken(true, false) != 3);
                throw this.tokener.createParseException(null, "Trailing object found in array", true);
lbl45:
                // 2 sources

                this.value = var4_4;
                this.token = 10;
                return 10;
            }
            case 6: {
                this.value = Boolean.TRUE;
                break;
            }
            case 7: {
                this.value = Boolean.FALSE;
                break;
            }
            case 5: {
                this.value = null;
                break;
            }
            case 8: 
            case 12: {
                this.value = this.tokener.reusableBuffer.toString();
                break;
            }
            case 9: {
                if (this.lazyNumbers) {
                    this.value = new JsonLazyNumber(this.tokener.reusableBuffer.toString(), this.tokener.isDouble);
                    break;
                }
                this.value = this.parseNumber();
                break;
            }
        }
        return this.token;
    }

    private Number parseNumber() throws JsonParserException {
        String string = this.tokener.reusableBuffer.toString();
        try {
            int n;
            if (this.tokener.isDouble) {
                return Double.parseDouble(string);
            }
            if (string.length() == 1) {
                return string.charAt(0) - 48;
            }
            if (string.length() == 2 && string.charAt(0) == '-') {
                return 48 - string.charAt(1);
            }
            boolean bl = string.charAt(0) == '-';
            int n2 = n = bl ? string.length() - 1 : string.length();
            if (n < 10 || n == 10 && string.charAt(bl ? 1 : 0) < '2') {
                return Integer.parseInt(string);
            }
            if (n < 19 || n == 19 && string.charAt(bl ? 1 : 0) < '9') {
                return Long.parseLong(string);
            }
            return new BigInteger(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw this.tokener.createParseException(numberFormatException, "Malformed number: " + string, true);
        }
    }

    public static final class JsonParserContext<T> {
        private final Class<T> clazz;
        private boolean lazyNumbers;

        JsonParserContext(Class<T> clazz) {
            this.clazz = clazz;
        }

        public JsonParserContext<T> withLazyNumbers() {
            this.lazyNumbers = true;
            return this;
        }

        public T from(String string) throws JsonParserException {
            return new JsonParser(new JsonTokener(new StringReader(string)), this.lazyNumbers).parse(this.clazz);
        }

        public T from(Reader reader) throws JsonParserException {
            return new JsonParser(new JsonTokener(reader), this.lazyNumbers).parse(this.clazz);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public T from(URL uRL) throws JsonParserException {
            try (InputStream inputStream = uRL.openStream();){
                T t = this.from(inputStream);
                return t;
            }
            catch (IOException iOException) {
                throw new JsonParserException(iOException, "IOException opening URL", 1, 1, 0);
            }
        }

        public T from(InputStream inputStream) throws JsonParserException {
            return new JsonParser(new JsonTokener(inputStream), this.lazyNumbers).parse(this.clazz);
        }
    }
}

