/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.jsoup.helper;

import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jspecify.annotations.Nullable;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.watermedia.shaded.javax.xml.parsers.DocumentBuilder;
import org.watermedia.shaded.javax.xml.parsers.DocumentBuilderFactory;
import org.watermedia.shaded.javax.xml.parsers.ParserConfigurationException;
import org.watermedia.shaded.javax.xml.transform.Result;
import org.watermedia.shaded.javax.xml.transform.Source;
import org.watermedia.shaded.javax.xml.transform.Transformer;
import org.watermedia.shaded.javax.xml.transform.TransformerException;
import org.watermedia.shaded.javax.xml.transform.TransformerFactory;
import org.watermedia.shaded.javax.xml.transform.dom.DOMSource;
import org.watermedia.shaded.javax.xml.transform.stream.StreamResult;
import org.watermedia.shaded.javax.xml.xpath.XPathConstants;
import org.watermedia.shaded.javax.xml.xpath.XPathExpression;
import org.watermedia.shaded.javax.xml.xpath.XPathExpressionException;
import org.watermedia.shaded.javax.xml.xpath.XPathFactory;
import org.watermedia.shaded.javax.xml.xpath.XPathFactoryConfigurationException;
import org.watermedia.shaded.jsoup.helper.Validate;
import org.watermedia.shaded.jsoup.internal.Normalizer;
import org.watermedia.shaded.jsoup.internal.StringUtil;
import org.watermedia.shaded.jsoup.nodes.Attribute;
import org.watermedia.shaded.jsoup.nodes.DataNode;
import org.watermedia.shaded.jsoup.nodes.Document;
import org.watermedia.shaded.jsoup.nodes.TextNode;
import org.watermedia.shaded.jsoup.parser.HtmlTreeBuilder;
import org.watermedia.shaded.jsoup.select.NodeVisitor;
import org.watermedia.shaded.jsoup.select.Selector;

public class W3CDom {
    public static final String SourceProperty = "jsoupSource";
    private static final String ContextProperty = "jsoupContextSource";
    private static final String ContextNodeProperty = "jsoupContextNode";
    public static final String XPathFactoryProperty = "org.watermedia.shaded.javax.xml.xpath.XPathFactory:jsoup";
    protected DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
    private boolean namespaceAware = true;

    public W3CDom() {
        this.factory.setNamespaceAware(true);
    }

    public boolean namespaceAware() {
        return this.namespaceAware;
    }

    public W3CDom namespaceAware(boolean namespaceAware) {
        this.namespaceAware = namespaceAware;
        this.factory.setNamespaceAware(namespaceAware);
        return this;
    }

    public static org.w3c.dom.Document convert(Document in) {
        return new W3CDom().fromJsoup(in);
    }

    public static String asString(org.w3c.dom.Document doc, @Nullable Map<String, String> properties) {
        try {
            DOMSource domSource = new DOMSource((Node)doc);
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult((Writer)writer);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            if (properties != null) {
                transformer.setOutputProperties(W3CDom.propertiesFromMap(properties));
            }
            if (doc.getDoctype() != null) {
                DocumentType doctype = doc.getDoctype();
                if (!StringUtil.isBlank(doctype.getPublicId())) {
                    transformer.setOutputProperty("doctype-public", doctype.getPublicId());
                }
                if (!StringUtil.isBlank(doctype.getSystemId())) {
                    transformer.setOutputProperty("doctype-system", doctype.getSystemId());
                } else if (doctype.getName().equalsIgnoreCase("html") && StringUtil.isBlank(doctype.getPublicId()) && StringUtil.isBlank(doctype.getSystemId())) {
                    transformer.setOutputProperty("doctype-system", "about:legacy-compat");
                }
            }
            transformer.transform((Source)domSource, (Result)result);
            return writer.toString();
        }
        catch (TransformerException e) {
            throw new IllegalStateException(e);
        }
    }

    static Properties propertiesFromMap(Map<String, String> map) {
        Properties props = new Properties();
        props.putAll(map);
        return props;
    }

    public static HashMap<String, String> OutputHtml() {
        return W3CDom.methodMap("html");
    }

    public static HashMap<String, String> OutputXml() {
        return W3CDom.methodMap("xml");
    }

    private static HashMap<String, String> methodMap(String method) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("method", method);
        return map;
    }

    public org.w3c.dom.Document fromJsoup(Document in) {
        return this.fromJsoup((org.watermedia.shaded.jsoup.nodes.Element)in);
    }

    public org.w3c.dom.Document fromJsoup(org.watermedia.shaded.jsoup.nodes.Element in) {
        Validate.notNull(in);
        try {
            org.watermedia.shaded.jsoup.nodes.DocumentType doctype;
            DocumentBuilder builder = this.factory.newDocumentBuilder();
            DOMImplementation impl = builder.getDOMImplementation();
            org.w3c.dom.Document out = builder.newDocument();
            Document inDoc = in.ownerDocument();
            org.watermedia.shaded.jsoup.nodes.DocumentType documentType = doctype = inDoc != null ? inDoc.documentType() : null;
            if (doctype != null) {
                try {
                    DocumentType documentType2 = impl.createDocumentType(doctype.name(), doctype.publicId(), doctype.systemId());
                    out.appendChild(documentType2);
                }
                catch (DOMException documentType2) {
                    // empty catch block
                }
            }
            out.setXmlStandalone(true);
            org.watermedia.shaded.jsoup.nodes.Element context = in instanceof Document ? in.firstElementChild() : in;
            out.setUserData(ContextProperty, context, null);
            this.convert(inDoc != null ? inDoc : in, out);
            return out;
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException(e);
        }
    }

    public void convert(Document in, org.w3c.dom.Document out) {
        this.convert((org.watermedia.shaded.jsoup.nodes.Element)in, out);
    }

    public void convert(org.watermedia.shaded.jsoup.nodes.Element in, org.w3c.dom.Document out) {
        org.watermedia.shaded.jsoup.nodes.Element rootEl;
        W3CBuilder builder = new W3CBuilder(out);
        builder.namespaceAware = this.namespaceAware;
        Document inDoc = in.ownerDocument();
        if (inDoc != null) {
            if (!StringUtil.isBlank(inDoc.location())) {
                out.setDocumentURI(inDoc.location());
            }
            builder.syntax = inDoc.outputSettings().syntax();
        }
        org.watermedia.shaded.jsoup.nodes.Element element = rootEl = in instanceof Document ? in.firstElementChild() : in;
        assert (rootEl != null);
        builder.traverse(rootEl);
    }

    public NodeList selectXpath(String xpath, org.w3c.dom.Document doc) {
        return this.selectXpath(xpath, (Node)doc);
    }

    public NodeList selectXpath(String xpath, Node contextNode) {
        NodeList nodeList;
        Validate.notEmptyParam(xpath, "xpath");
        Validate.notNullParam(contextNode, "contextNode");
        try {
            String property = System.getProperty(XPathFactoryProperty);
            XPathFactory xPathFactory = property != null ? XPathFactory.newInstance((String)"jsoup") : XPathFactory.newInstance();
            XPathExpression expression = xPathFactory.newXPath().compile(xpath);
            nodeList = (NodeList)expression.evaluate((Object)contextNode, XPathConstants.NODESET);
            Validate.notNull(nodeList);
        }
        catch (XPathExpressionException | XPathFactoryConfigurationException e) {
            throw new Selector.SelectorParseException(e, "Could not evaluate XPath query [%s]: %s", xpath, e.getMessage());
        }
        return nodeList;
    }

    public <T extends org.watermedia.shaded.jsoup.nodes.Node> List<T> sourceNodes(NodeList nodeList, Class<T> nodeType) {
        Validate.notNull(nodeList);
        Validate.notNull(nodeType);
        ArrayList<org.watermedia.shaded.jsoup.nodes.Node> nodes = new ArrayList<org.watermedia.shaded.jsoup.nodes.Node>(nodeList.getLength());
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            Object source = node.getUserData(SourceProperty);
            if (!nodeType.isInstance(source)) continue;
            nodes.add((org.watermedia.shaded.jsoup.nodes.Node)nodeType.cast(source));
        }
        return nodes;
    }

    public Node contextNode(org.w3c.dom.Document wDoc) {
        return (Node)wDoc.getUserData(ContextNodeProperty);
    }

    public String asString(org.w3c.dom.Document doc) {
        return W3CDom.asString(doc, null);
    }

    protected static class W3CBuilder
    implements NodeVisitor {
        private final org.w3c.dom.Document doc;
        private boolean namespaceAware = true;
        private Node dest;
        private Document.OutputSettings.Syntax syntax = Document.OutputSettings.Syntax.xml;
        private final org.watermedia.shaded.jsoup.nodes.Element contextElement;
        private static final String undefinedNs = "undefined";

        public W3CBuilder(org.w3c.dom.Document doc) {
            this.doc = doc;
            this.dest = doc;
            this.contextElement = (org.watermedia.shaded.jsoup.nodes.Element)doc.getUserData(W3CDom.ContextProperty);
        }

        @Override
        public void head(org.watermedia.shaded.jsoup.nodes.Node source, int depth) {
            if (source instanceof org.watermedia.shaded.jsoup.nodes.Element) {
                org.watermedia.shaded.jsoup.nodes.Element sourceEl = (org.watermedia.shaded.jsoup.nodes.Element)source;
                String namespace = this.namespaceAware ? sourceEl.tag().namespace() : null;
                String tagName = Normalizer.xmlSafeTagName(sourceEl.tagName());
                try {
                    String imputedNamespace = namespace == null && tagName.contains(":") ? "" : namespace;
                    Element el2 = this.doc.createElementNS(imputedNamespace, tagName);
                    this.copyAttributes(sourceEl, el2);
                    this.append(el2, sourceEl);
                    if (sourceEl == this.contextElement) {
                        this.doc.setUserData(W3CDom.ContextNodeProperty, el2, null);
                    }
                    this.dest = el2;
                }
                catch (DOMException e) {
                    this.append(this.doc.createTextNode("<" + tagName + ">"), sourceEl);
                }
            } else if (source instanceof TextNode) {
                TextNode sourceText = (TextNode)source;
                Text text = this.doc.createTextNode(sourceText.getWholeText());
                this.append(text, sourceText);
            } else if (source instanceof org.watermedia.shaded.jsoup.nodes.Comment) {
                org.watermedia.shaded.jsoup.nodes.Comment sourceComment = (org.watermedia.shaded.jsoup.nodes.Comment)source;
                Comment comment = this.doc.createComment(sourceComment.getData());
                this.append(comment, sourceComment);
            } else if (source instanceof DataNode) {
                DataNode sourceData = (DataNode)source;
                Text node = this.doc.createTextNode(sourceData.getWholeData());
                this.append(node, sourceData);
            }
        }

        private void append(Node append, org.watermedia.shaded.jsoup.nodes.Node source) {
            append.setUserData(W3CDom.SourceProperty, source, null);
            this.dest.appendChild(append);
        }

        @Override
        public void tail(org.watermedia.shaded.jsoup.nodes.Node source, int depth) {
            if (source instanceof org.watermedia.shaded.jsoup.nodes.Element && this.dest.getParentNode() instanceof Element) {
                this.dest = this.dest.getParentNode();
            }
        }

        private void copyAttributes(org.watermedia.shaded.jsoup.nodes.Element jEl, Element wEl) {
            for (Attribute attribute : jEl.attributes()) {
                try {
                    this.setAttribute(jEl, wEl, attribute, this.syntax);
                }
                catch (DOMException e) {
                    if (this.syntax == Document.OutputSettings.Syntax.xml) continue;
                    this.setAttribute(jEl, wEl, attribute, Document.OutputSettings.Syntax.xml);
                }
            }
        }

        private void setAttribute(org.watermedia.shaded.jsoup.nodes.Element jEl, Element wEl, Attribute attribute, Document.OutputSettings.Syntax syntax) throws DOMException {
            String key = Attribute.getValidKey(attribute.getKey(), syntax);
            if (key != null) {
                String namespace = attribute.namespace();
                if (this.namespaceAware && !namespace.isEmpty()) {
                    wEl.setAttributeNS(namespace, key, attribute.getValue());
                } else {
                    wEl.setAttribute(key, attribute.getValue());
                }
                this.maybeAddUndeclaredNs(namespace, key, jEl, wEl);
            }
        }

        private void maybeAddUndeclaredNs(String namespace, String attrKey, org.watermedia.shaded.jsoup.nodes.Element jEl, Element wEl) {
            if (!this.namespaceAware || !namespace.isEmpty()) {
                return;
            }
            int pos = attrKey.indexOf(58);
            if (pos != -1) {
                String prefix = attrKey.substring(0, pos);
                if (prefix.equals("xmlns")) {
                    return;
                }
                Document doc = jEl.ownerDocument();
                if (doc != null && doc.parser().getTreeBuilder() instanceof HtmlTreeBuilder) {
                    for (org.watermedia.shaded.jsoup.nodes.Element el2 = jEl; el2 != null; el2 = el2.parent()) {
                        String ns = el2.attr("xmlns:" + prefix);
                        if (ns.isEmpty()) continue;
                        namespace = ns;
                        wEl.setAttributeNS(namespace, attrKey, jEl.attr(attrKey));
                        return;
                    }
                }
                wEl.setAttribute("xmlns:" + prefix, undefinedNs);
            }
        }
    }
}

