/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.jsoup.nodes;

import org.jspecify.annotations.Nullable;
import org.watermedia.shaded.jsoup.internal.QuietAppendable;
import org.watermedia.shaded.jsoup.internal.StringUtil;
import org.watermedia.shaded.jsoup.nodes.Document;
import org.watermedia.shaded.jsoup.nodes.Element;
import org.watermedia.shaded.jsoup.nodes.Entities;
import org.watermedia.shaded.jsoup.nodes.LeafNode;
import org.watermedia.shaded.jsoup.nodes.Node;
import org.watermedia.shaded.jsoup.nodes.NodeUtils;
import org.watermedia.shaded.jsoup.nodes.TextNode;
import org.watermedia.shaded.jsoup.parser.Tag;
import org.watermedia.shaded.jsoup.select.NodeVisitor;

class Printer
implements NodeVisitor {
    final Node root;
    final QuietAppendable accum;
    final Document.OutputSettings settings;

    Printer(Node root, QuietAppendable accum, Document.OutputSettings settings) {
        this.root = root;
        this.accum = accum;
        this.settings = settings;
    }

    void addHead(Element el2, int depth) {
        el2.outerHtmlHead(this.accum, this.settings);
    }

    void addTail(Element el2, int depth) {
        el2.outerHtmlTail(this.accum, this.settings);
    }

    void addText(TextNode textNode, int textOptions, int depth) {
        int options = 1 | textOptions;
        Entities.escape(this.accum, textNode.coreValue(), this.settings, options);
    }

    void addNode(LeafNode node, int depth) {
        node.outerHtmlHead(this.accum, this.settings);
    }

    void indent(int depth) {
        this.accum.append('\n').append(StringUtil.padding(depth * this.settings.indentAmount(), this.settings.maxPaddingWidth()));
    }

    @Override
    public void head(Node node, int depth) {
        if (node.getClass() == TextNode.class) {
            this.addText((TextNode)node, 0, depth);
        } else if (node instanceof Element) {
            this.addHead((Element)node, depth);
        } else {
            this.addNode((LeafNode)node, depth);
        }
    }

    @Override
    public void tail(Node node, int depth) {
        if (node instanceof Element) {
            this.addTail((Element)node, depth);
        }
    }

    static Printer printerFor(Node root, QuietAppendable accum) {
        Document.OutputSettings settings = NodeUtils.outputSettings(root);
        if (settings.outline()) {
            return new Outline(root, accum, settings);
        }
        if (settings.prettyPrint()) {
            return new Pretty(root, accum, settings);
        }
        return new Printer(root, accum, settings);
    }

    static class Outline
    extends Pretty {
        Outline(Node root, QuietAppendable accum, Document.OutputSettings settings) {
            super(root, accum, settings);
        }

        @Override
        boolean isBlockEl(@Nullable Node node) {
            return node != null;
        }

        @Override
        boolean shouldIndent(@Nullable Node node) {
            if (node == null || node == this.root || this.preserveWhitespace || Outline.isBlankText(node)) {
                return false;
            }
            if (node instanceof TextNode) {
                return node.previousSibling() != null || node.nextSibling() != null;
            }
            return true;
        }
    }

    static class Pretty
    extends Printer {
        boolean preserveWhitespace = false;
        private static final int maxScan = 5;

        Pretty(Node root, QuietAppendable accum, Document.OutputSettings settings) {
            super(root, accum, settings);
            for (Node node = root; node != null; node = node.parentNode()) {
                if (!Pretty.tagIs(Tag.PreserveWhitespace, node)) continue;
                this.preserveWhitespace = true;
                break;
            }
        }

        @Override
        void addHead(Element el2, int depth) {
            if (this.shouldIndent(el2)) {
                this.indent(depth);
            }
            super.addHead(el2, depth);
            if (Pretty.tagIs(Tag.PreserveWhitespace, el2)) {
                this.preserveWhitespace = true;
            }
        }

        @Override
        void addTail(Element el2, int depth) {
            if (this.shouldIndent(Pretty.nextNonBlank(el2.firstChild()))) {
                this.indent(depth);
            }
            super.addTail(el2, depth);
            if (this.preserveWhitespace && el2.tag.is(Tag.PreserveWhitespace)) {
                for (Element parent = el2.parent(); parent != null; parent = parent.parent()) {
                    if (!parent.tag().preserveWhitespace()) continue;
                    return;
                }
                this.preserveWhitespace = false;
            }
        }

        @Override
        void addNode(LeafNode node, int depth) {
            if (this.shouldIndent(node)) {
                this.indent(depth);
            }
            super.addNode(node, depth);
        }

        @Override
        void addText(TextNode node, int textOptions, int depth) {
            if (!this.preserveWhitespace) {
                textOptions |= 4;
                textOptions = this.textTrim(node, textOptions);
                if (!node.isBlank() && this.isBlockEl(node.parentNode) && this.shouldIndent(node)) {
                    this.indent(depth);
                }
            }
            super.addText(node, textOptions, depth);
        }

        int textTrim(TextNode node, int options) {
            if (!this.isBlockEl(node.parentNode)) {
                return options;
            }
            Node prev = node.previousSibling();
            Node next = node.nextSibling();
            if ((!(prev instanceof Element) || this.isBlockEl(prev)) && (prev == null || !(prev instanceof TextNode) && this.shouldIndent(prev))) {
                options |= 8;
            }
            if (next == null || !(next instanceof TextNode) && this.shouldIndent(next)) {
                options |= 0x10;
            }
            return options;
        }

        boolean shouldIndent(@Nullable Node node) {
            if (node == null || node == this.root || this.preserveWhitespace || Pretty.isBlankText(node)) {
                return false;
            }
            if (this.isBlockEl(node)) {
                return true;
            }
            Node prevSib = Pretty.previousNonblank(node);
            if (this.isBlockEl(prevSib)) {
                return true;
            }
            Element parent = node.parentNode;
            if (!this.isBlockEl(parent) || parent.tag().is(Tag.InlineContainer) || !Pretty.hasNonTextNodes(parent)) {
                return false;
            }
            return prevSib == null || !(prevSib instanceof TextNode) && (this.isBlockEl(prevSib) || !(prevSib instanceof Element));
        }

        boolean isBlockEl(@Nullable Node node) {
            if (node == null) {
                return false;
            }
            if (node instanceof Element) {
                Element el2 = (Element)node;
                return el2.isBlock() || !el2.tag.isKnownTag() && (el2.parentNode instanceof Document || Pretty.hasChildBlocks(el2));
            }
            return false;
        }

        static boolean hasChildBlocks(Element el2) {
            Element child = el2.firstElementChild();
            for (int i = 0; i < 5 && child != null; child = child.nextElementSibling(), ++i) {
                if (!child.isBlock() && child.tag.isKnownTag()) continue;
                return true;
            }
            return false;
        }

        static boolean hasNonTextNodes(Element el2) {
            Node child = el2.firstChild();
            for (int i = 0; i < 5 && child != null; child = child.nextSibling(), ++i) {
                if (child instanceof TextNode) continue;
                return true;
            }
            return false;
        }

        static @Nullable Node previousNonblank(Node node) {
            Node prev = node.previousSibling();
            while (Pretty.isBlankText(prev)) {
                prev = prev.previousSibling();
            }
            return prev;
        }

        static @Nullable Node nextNonBlank(@Nullable Node node) {
            while (Pretty.isBlankText(node)) {
                node = node.nextSibling();
            }
            return node;
        }

        static boolean isBlankText(@Nullable Node node) {
            return node instanceof TextNode && ((TextNode)node).isBlank();
        }

        static boolean tagIs(int option, @Nullable Node node) {
            return node instanceof Element && ((Element)node).tag.is(option);
        }
    }
}

