/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.jsoup.select;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Map;
import org.watermedia.shaded.jsoup.internal.Functions;
import org.watermedia.shaded.jsoup.internal.SoftPool;
import org.watermedia.shaded.jsoup.internal.StringUtil;
import org.watermedia.shaded.jsoup.nodes.Element;
import org.watermedia.shaded.jsoup.nodes.LeafNode;
import org.watermedia.shaded.jsoup.nodes.Node;
import org.watermedia.shaded.jsoup.nodes.NodeIterator;
import org.watermedia.shaded.jsoup.nodes.TextNode;
import org.watermedia.shaded.jsoup.select.CombiningEvaluator;
import org.watermedia.shaded.jsoup.select.Evaluator;

abstract class StructuralEvaluator
extends Evaluator {
    final Evaluator evaluator;
    boolean wantsNodes;
    final ThreadLocal<IdentityHashMap<Node, IdentityHashMap<Node, Boolean>>> threadMemo = ThreadLocal.withInitial(IdentityHashMap::new);

    public StructuralEvaluator(Evaluator evaluator) {
        this.evaluator = evaluator;
        this.wantsNodes = evaluator.wantsNodes();
    }

    @Override
    boolean wantsNodes() {
        return this.wantsNodes;
    }

    boolean memoMatches(Element root, Node node) {
        Map rootMemo = this.threadMemo.get();
        Map memo = rootMemo.computeIfAbsent(root, Functions.identityMapFunction());
        return memo.computeIfAbsent(node, key -> this.evaluator.matches(root, (Node)key));
    }

    @Override
    protected void reset() {
        this.threadMemo.get().clear();
        this.evaluator.reset();
        super.reset();
    }

    @Override
    public boolean matches(Element root, Element element) {
        return this.evaluateMatch(root, element);
    }

    @Override
    boolean matches(Element root, LeafNode leafNode) {
        return this.evaluateMatch(root, leafNode);
    }

    abstract boolean evaluateMatch(Element var1, Node var2);

    static class ImmediatePreviousSibling
    extends StructuralEvaluator {
        public ImmediatePreviousSibling(Evaluator evaluator) {
            super(evaluator);
        }

        @Override
        boolean evaluateMatch(Element root, Node node) {
            if (root == node) {
                return false;
            }
            Node prev = this.wantsNodes ? node.previousSibling() : node.previousElementSibling();
            return prev != null && this.memoMatches(root, prev);
        }

        @Override
        protected int cost() {
            return 2 + this.evaluator.cost();
        }

        public String toString() {
            return String.format("%s + ", this.evaluator);
        }
    }

    static class PreviousSibling
    extends StructuralEvaluator {
        public PreviousSibling(Evaluator evaluator) {
            super(evaluator);
        }

        @Override
        boolean evaluateMatch(Element root, Node node) {
            if (root == node) {
                return false;
            }
            for (Node sib = node.firstSibling(); sib != null && sib != node; sib = sib.nextSibling()) {
                if (!this.memoMatches(root, sib)) continue;
                return true;
            }
            return false;
        }

        @Override
        protected int cost() {
            return 3 * this.evaluator.cost();
        }

        public String toString() {
            return String.format("%s ~ ", this.evaluator);
        }
    }

    static class ImmediateParentRun
    extends StructuralEvaluator {
        final ArrayList<Evaluator> evaluators = new ArrayList();
        int cost = 2;

        public ImmediateParentRun(Evaluator evaluator) {
            super(evaluator);
            this.evaluators.add(evaluator);
            this.cost += evaluator.cost();
        }

        void add(Evaluator evaluator) {
            this.evaluators.add(evaluator);
            this.cost += evaluator.cost();
            this.wantsNodes |= evaluator.wantsNodes();
        }

        @Override
        boolean evaluateMatch(Element root, Node node) {
            if (node == root) {
                return false;
            }
            for (int i = this.evaluators.size() - 1; i >= 0; --i) {
                if (node == null) {
                    return false;
                }
                Evaluator eval = this.evaluators.get(i);
                if (!eval.matches(root, node)) {
                    return false;
                }
                node = node.parent();
            }
            return true;
        }

        @Override
        protected int cost() {
            return this.cost;
        }

        @Override
        protected void reset() {
            for (Evaluator evaluator : this.evaluators) {
                evaluator.reset();
            }
            super.reset();
        }

        public String toString() {
            return StringUtil.join(this.evaluators, " > ");
        }
    }

    static class Ancestor
    extends StructuralEvaluator {
        public Ancestor(Evaluator evaluator) {
            super(evaluator);
        }

        @Override
        boolean evaluateMatch(Element root, Node node) {
            if (root == node) {
                return false;
            }
            for (Node parent = node.parent(); parent != null; parent = parent.parent()) {
                if (this.memoMatches(root, parent)) {
                    return true;
                }
                if (parent == root) break;
            }
            return false;
        }

        @Override
        protected int cost() {
            return 8 * this.evaluator.cost();
        }

        public String toString() {
            return String.format("%s ", this.evaluator);
        }
    }

    static class Not
    extends StructuralEvaluator {
        public Not(Evaluator evaluator) {
            super(evaluator);
        }

        @Override
        boolean evaluateMatch(Element root, Node node) {
            return !this.memoMatches(root, node);
        }

        @Override
        protected int cost() {
            return 2 + this.evaluator.cost();
        }

        public String toString() {
            return String.format(":not(%s)", this.evaluator);
        }
    }

    static class Is
    extends StructuralEvaluator {
        public Is(Evaluator evaluator) {
            super(evaluator);
        }

        @Override
        boolean evaluateMatch(Element root, Node node) {
            return this.evaluator.matches(root, node);
        }

        @Override
        protected int cost() {
            return 2 + this.evaluator.cost();
        }

        public String toString() {
            return String.format(":is(%s)", this.evaluator);
        }
    }

    static class Has
    extends StructuralEvaluator {
        static final SoftPool<NodeIterator<Node>> NodeIterPool = new SoftPool<NodeIterator>(() -> new NodeIterator<Node>(new TextNode(""), Node.class));
        private final boolean checkSiblings;

        public Has(Evaluator evaluator) {
            super(evaluator);
            this.checkSiblings = Has.evalWantsSiblings(evaluator);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean matches(Element root, Element element) {
            if (this.checkSiblings) {
                for (Element sib = element.firstElementSibling(); sib != null; sib = sib.nextElementSibling()) {
                    if (sib == element || !this.evaluator.matches(element, sib)) continue;
                    return true;
                }
            }
            NodeIterator<Node> it2 = NodeIterPool.borrow();
            it2.restart(element);
            try {
                while (it2.hasNext()) {
                    Object node = it2.next();
                    if (node == element) continue;
                    if (!this.evaluator.matches(element, (Node)node)) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                NodeIterPool.release(it2);
            }
            return false;
        }

        @Override
        boolean evaluateMatch(Element root, Node node) {
            return false;
        }

        private static boolean evalWantsSiblings(Evaluator eval) {
            if (eval instanceof CombiningEvaluator) {
                CombiningEvaluator ce = (CombiningEvaluator)eval;
                for (Evaluator innerEval : ce.evaluators) {
                    if (!(innerEval instanceof PreviousSibling) && !(innerEval instanceof ImmediatePreviousSibling)) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        protected int cost() {
            return 10 * this.evaluator.cost();
        }

        public String toString() {
            return String.format(":has(%s)", this.evaluator);
        }
    }

    static class Root
    extends Evaluator {
        Root() {
        }

        @Override
        public boolean matches(Element root, Element element) {
            return root == element;
        }

        @Override
        protected int cost() {
            return 1;
        }

        public String toString() {
            return ">";
        }
    }
}

