/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.mozilla.javascript;

import java.util.EnumSet;
import org.watermedia.shaded.mozilla.javascript.BaseFunction;
import org.watermedia.shaded.mozilla.javascript.Callable;
import org.watermedia.shaded.mozilla.javascript.Context;
import org.watermedia.shaded.mozilla.javascript.DecompilerFlag;
import org.watermedia.shaded.mozilla.javascript.EqualObjectGraphs;
import org.watermedia.shaded.mozilla.javascript.Function;
import org.watermedia.shaded.mozilla.javascript.NativeObject;
import org.watermedia.shaded.mozilla.javascript.ScriptRuntime;
import org.watermedia.shaded.mozilla.javascript.Scriptable;
import org.watermedia.shaded.mozilla.javascript.TopLevel;

public class ArrowFunction
extends BaseFunction {
    private static final long serialVersionUID = -7377989503697220633L;
    private final Callable targetFunction;
    private final Scriptable boundThis;
    private final Scriptable boundHomeObject;

    public ArrowFunction(Context cx, Scriptable scope, Callable targetFunction, Scriptable boundThis, Scriptable boundHomeObject) {
        this.targetFunction = targetFunction;
        this.boundThis = boundThis;
        this.boundHomeObject = boundHomeObject;
        ScriptRuntime.setFunctionProtoAndParent(this, cx, scope, false);
        BaseFunction thrower = ScriptRuntime.typeErrorThrower(cx);
        NativeObject throwing = new NativeObject();
        ScriptRuntime.setBuiltinProtoAndParent(throwing, scope, TopLevel.Builtins.Object);
        throwing.put("get", (Scriptable)throwing, (Object)thrower);
        throwing.put("set", (Scriptable)throwing, (Object)thrower);
        throwing.put("enumerable", (Scriptable)throwing, (Object)Boolean.FALSE);
        throwing.put("configurable", (Scriptable)throwing, (Object)Boolean.FALSE);
        throwing.preventExtensions();
        this.defineOwnProperty(cx, "caller", throwing, false);
        this.defineOwnProperty(cx, "arguments", throwing, false);
    }

    @Override
    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        return this.targetFunction.call(cx, scope, this.getCallThis(cx), args);
    }

    @Override
    public Scriptable construct(Context cx, Scriptable scope, Object[] args) {
        throw ScriptRuntime.typeErrorById("msg.not.ctor", this.decompile(0, EnumSet.noneOf(DecompilerFlag.class)));
    }

    @Override
    public boolean hasInstance(Scriptable instance) {
        if (this.targetFunction instanceof Function) {
            return ((Function)this.targetFunction).hasInstance(instance);
        }
        throw ScriptRuntime.typeErrorById("msg.not.ctor", new Object[0]);
    }

    @Override
    public int getLength() {
        if (this.targetFunction instanceof BaseFunction) {
            return ((BaseFunction)this.targetFunction).getLength();
        }
        return 0;
    }

    @Override
    public int getArity() {
        return this.getLength();
    }

    @Override
    String decompile(int indent, EnumSet<DecompilerFlag> flags) {
        if (this.targetFunction instanceof BaseFunction) {
            return ((BaseFunction)this.targetFunction).decompile(indent, flags);
        }
        return super.decompile(indent, flags);
    }

    Scriptable getCallThis(Context cx) {
        return this.boundThis != null ? this.boundThis : ScriptRuntime.getTopCallScope(cx);
    }

    Scriptable getBoundHomeObject() {
        return this.boundHomeObject;
    }

    Callable getTargetFunction() {
        return this.targetFunction;
    }

    static boolean equalObjectGraphs(ArrowFunction f1, ArrowFunction f2, EqualObjectGraphs eq) {
        return eq.equalGraphs(f1.boundThis, f2.boundThis) && eq.equalGraphs(f1.targetFunction, f2.targetFunction);
    }
}

