/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.mozilla.javascript.engine;

import org.watermedia.shaded.javax.script.Bindings;
import org.watermedia.shaded.mozilla.javascript.Context;
import org.watermedia.shaded.mozilla.javascript.Scriptable;
import org.watermedia.shaded.mozilla.javascript.ScriptableObject;

public class BindingsObject
extends ScriptableObject {
    private final Bindings bindings;

    BindingsObject(Bindings bindings) {
        if (bindings == null) {
            throw new IllegalArgumentException("Bindings must not be null");
        }
        this.bindings = bindings;
    }

    @Override
    public String getClassName() {
        return "BindingsObject";
    }

    @Override
    public Object get(String name, Scriptable start) {
        if (!this.bindings.containsKey((Object)name)) {
            return Scriptable.NOT_FOUND;
        }
        return Context.jsToJava(this.bindings.get((Object)name), Object.class);
    }

    @Override
    public void put(String name, Scriptable start, Object value) {
        this.bindings.put(name, Context.javaToJS(value, start));
    }

    @Override
    public void delete(String name) {
        this.bindings.remove((Object)name);
    }

    @Override
    public boolean has(String name, Scriptable start) {
        return this.bindings.containsKey((Object)name);
    }

    @Override
    public Object[] getIds() {
        return this.bindings.keySet().toArray();
    }
}

