/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor;

import java.io.Serializable;
import java.util.Objects;
import org.watermedia.shaded.javax.annotation.Nonnull;

public final class Image
implements Serializable {
    public static final int HEIGHT_UNKNOWN = -1;
    public static final int WIDTH_UNKNOWN = -1;
    @Nonnull
    private final String url;
    private final int height;
    private final int width;
    @Nonnull
    private final ResolutionLevel estimatedResolutionLevel;

    public Image(@Nonnull String url, int height, int width, @Nonnull ResolutionLevel estimatedResolutionLevel) throws NullPointerException {
        this.url = url;
        this.height = height;
        this.width = width;
        this.estimatedResolutionLevel = Objects.requireNonNull(estimatedResolutionLevel, "estimatedResolutionLevel is null");
    }

    @Nonnull
    public String getUrl() {
        return this.url;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    @Nonnull
    public ResolutionLevel getEstimatedResolutionLevel() {
        return this.estimatedResolutionLevel;
    }

    @Nonnull
    public String toString() {
        return "Image {url=" + this.url + ", height=" + this.height + ", width=" + this.width + ", estimatedResolutionLevel=" + this.estimatedResolutionLevel + "}";
    }

    public static enum ResolutionLevel {
        HIGH,
        MEDIUM,
        LOW,
        UNKNOWN;


        public static ResolutionLevel fromHeight(int heightPx) {
            if (heightPx <= 0) {
                return UNKNOWN;
            }
            if (heightPx < 175) {
                return LOW;
            }
            if (heightPx < 720) {
                return MEDIUM;
            }
            return HIGH;
        }
    }
}

