/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.downloader;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.javax.annotation.Nullable;
import org.watermedia.shaded.schabi.newpipe.extractor.NewPipe;
import org.watermedia.shaded.schabi.newpipe.extractor.downloader.Request;
import org.watermedia.shaded.schabi.newpipe.extractor.downloader.Response;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ReCaptchaException;
import org.watermedia.shaded.schabi.newpipe.extractor.localization.Localization;

public abstract class Downloader {
    public Response get(String url) throws IOException, ReCaptchaException {
        return this.get(url, null, NewPipe.getPreferredLocalization());
    }

    public Response get(String url, Localization localization) throws IOException, ReCaptchaException {
        return this.get(url, null, localization);
    }

    public Response get(String url, @Nullable Map<String, List<String>> headers) throws IOException, ReCaptchaException {
        return this.get(url, headers, NewPipe.getPreferredLocalization());
    }

    public Response get(String url, @Nullable Map<String, List<String>> headers, Localization localization) throws IOException, ReCaptchaException {
        return this.execute(Request.newBuilder().get(url).headers(headers).localization(localization).build());
    }

    public Response head(String url) throws IOException, ReCaptchaException {
        return this.head(url, null);
    }

    public Response head(String url, @Nullable Map<String, List<String>> headers) throws IOException, ReCaptchaException {
        return this.execute(Request.newBuilder().head(url).headers(headers).build());
    }

    public Response post(String url, @Nullable Map<String, List<String>> headers, @Nullable byte[] dataToSend) throws IOException, ReCaptchaException {
        return this.post(url, headers, dataToSend, NewPipe.getPreferredLocalization());
    }

    public Response post(String url, @Nullable Map<String, List<String>> headers, @Nullable byte[] dataToSend, Localization localization) throws IOException, ReCaptchaException {
        return this.execute(Request.newBuilder().post(url, dataToSend).headers(headers).localization(localization).build());
    }

    public Response postWithContentType(String url, @Nullable Map<String, List<String>> headers, @Nullable byte[] dataToSend, Localization localization, String contentType) throws IOException, ReCaptchaException {
        HashMap<String, List<String>> actualHeaders = new HashMap<String, List<String>>();
        if (headers != null) {
            actualHeaders.putAll(headers);
        }
        actualHeaders.put("Content-Type", Collections.singletonList(contentType));
        return this.post(url, actualHeaders, dataToSend, localization);
    }

    public Response postWithContentType(String url, @Nullable Map<String, List<String>> headers, @Nullable byte[] dataToSend, String contentType) throws IOException, ReCaptchaException {
        return this.postWithContentType(url, headers, dataToSend, NewPipe.getPreferredLocalization(), contentType);
    }

    public Response postWithContentTypeJson(String url, @Nullable Map<String, List<String>> headers, @Nullable byte[] dataToSend, Localization localization) throws IOException, ReCaptchaException {
        return this.postWithContentType(url, headers, dataToSend, localization, "application/json");
    }

    public Response postWithContentTypeJson(String url, @Nullable Map<String, List<String>> headers, @Nullable byte[] dataToSend) throws IOException, ReCaptchaException {
        return this.postWithContentTypeJson(url, headers, dataToSend, NewPipe.getPreferredLocalization());
    }

    public abstract Response execute(@Nonnull Request var1) throws IOException, ReCaptchaException;
}

