/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.linkhandler;

import java.util.Objects;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.linkhandler.LinkHandler;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.Utils;

public abstract class LinkHandlerFactory {
    public abstract String getId(String var1) throws ParsingException, UnsupportedOperationException;

    public abstract String getUrl(String var1) throws ParsingException, UnsupportedOperationException;

    public abstract boolean onAcceptUrl(String var1) throws ParsingException;

    public String getUrl(String id2, String baseUrl) throws ParsingException, UnsupportedOperationException {
        return this.getUrl(id2);
    }

    public LinkHandler fromUrl(String url) throws ParsingException {
        if (Utils.isNullOrEmpty(url)) {
            throw new IllegalArgumentException("The url is null or empty");
        }
        String polishedUrl = Utils.followGoogleRedirectIfNeeded(url);
        String baseUrl = Utils.getBaseUrl(polishedUrl);
        return this.fromUrl(polishedUrl, baseUrl);
    }

    public LinkHandler fromUrl(String url, String baseUrl) throws ParsingException {
        Objects.requireNonNull(url, "URL cannot be null");
        if (!this.acceptUrl(url)) {
            throw new ParsingException("URL not accepted: " + url);
        }
        String id2 = this.getId(url);
        return new LinkHandler(url, this.getUrl(id2, baseUrl), id2);
    }

    public LinkHandler fromId(String id2) throws ParsingException {
        Objects.requireNonNull(id2, "ID cannot be null");
        String url = this.getUrl(id2);
        return new LinkHandler(url, url, id2);
    }

    public LinkHandler fromId(String id2, String baseUrl) throws ParsingException {
        Objects.requireNonNull(id2, "ID cannot be null");
        String url = this.getUrl(id2, baseUrl);
        return new LinkHandler(url, url, id2);
    }

    public boolean acceptUrl(String url) throws ParsingException {
        return this.onAcceptUrl(url);
    }
}

