/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.bandcamp.extractors;

import java.util.List;
import org.watermedia.shaded.com.grack.nanojson.JsonObject;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.schabi.newpipe.extractor.Image;
import org.watermedia.shaded.schabi.newpipe.extractor.comments.CommentsInfoItemExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.services.bandcamp.extractors.BandcampExtractorHelper;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.Description;

public class BandcampCommentsInfoItemExtractor
implements CommentsInfoItemExtractor {
    private final JsonObject review;
    private final String url;

    public BandcampCommentsInfoItemExtractor(JsonObject review, String url) {
        this.review = review;
        this.url = url;
    }

    @Override
    public String getName() throws ParsingException {
        return this.getCommentText().getContent();
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    @Nonnull
    public List<Image> getThumbnails() throws ParsingException {
        return this.getUploaderAvatars();
    }

    @Override
    @Nonnull
    public Description getCommentText() throws ParsingException {
        return new Description(this.review.getString("why"), 3);
    }

    @Override
    public String getUploaderName() throws ParsingException {
        return this.review.getString("name");
    }

    @Override
    @Nonnull
    public List<Image> getUploaderAvatars() {
        return BandcampExtractorHelper.getImagesFromImageId(this.review.getLong("image_id"), false);
    }
}

