/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.bandcamp.extractors;

import java.util.List;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.jsoup.nodes.Element;
import org.watermedia.shaded.schabi.newpipe.extractor.Image;
import org.watermedia.shaded.schabi.newpipe.extractor.playlist.PlaylistInfoItemExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.services.bandcamp.extractors.BandcampExtractorHelper;

public class BandcampPlaylistInfoItemExtractor
implements PlaylistInfoItemExtractor {
    private final Element searchResult;
    private final Element resultInfo;

    public BandcampPlaylistInfoItemExtractor(@Nonnull Element searchResult) {
        this.searchResult = searchResult;
        this.resultInfo = searchResult.getElementsByClass("result-info").first();
    }

    @Override
    public String getUploaderName() {
        return this.resultInfo.getElementsByClass("subhead").text().split(" by")[0];
    }

    @Override
    public String getUploaderUrl() {
        return null;
    }

    @Override
    public boolean isUploaderVerified() {
        return false;
    }

    @Override
    public long getStreamCount() {
        String length = this.resultInfo.getElementsByClass("length").text();
        return Integer.parseInt(length.split(" track")[0]);
    }

    @Override
    public String getName() {
        return this.resultInfo.getElementsByClass("heading").text();
    }

    @Override
    public String getUrl() {
        return this.resultInfo.getElementsByClass("itemurl").text();
    }

    @Override
    @Nonnull
    public List<Image> getThumbnails() {
        return BandcampExtractorHelper.getImagesFromSearchResult(this.searchResult);
    }
}

