/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.bandcamp.extractors;

import java.util.List;
import org.watermedia.shaded.com.grack.nanojson.JsonObject;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.javax.annotation.Nullable;
import org.watermedia.shaded.schabi.newpipe.extractor.Image;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.localization.DateWrapper;
import org.watermedia.shaded.schabi.newpipe.extractor.services.bandcamp.extractors.BandcampExtractorHelper;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.StreamInfoItemExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.StreamType;

public class BandcampRadioInfoItemExtractor
implements StreamInfoItemExtractor {
    private final JsonObject show;

    public BandcampRadioInfoItemExtractor(JsonObject radioShow) {
        this.show = radioShow;
    }

    @Override
    public long getDuration() {
        return 0L;
    }

    @Override
    @Nullable
    public String getShortDescription() {
        return this.show.getString("desc");
    }

    @Override
    @Nullable
    public String getTextualUploadDate() {
        return this.show.getString("date");
    }

    @Override
    @Nullable
    public DateWrapper getUploadDate() throws ParsingException {
        return BandcampExtractorHelper.parseDate(this.getTextualUploadDate());
    }

    @Override
    public String getName() throws ParsingException {
        return this.show.getString("subtitle");
    }

    @Override
    public String getUrl() {
        return "https://bandcamp.com/?show=" + this.show.getInt("id");
    }

    @Override
    @Nonnull
    public List<Image> getThumbnails() {
        return BandcampExtractorHelper.getImagesFromImageId(this.show.getLong("image_id"), false);
    }

    @Override
    public StreamType getStreamType() {
        return StreamType.AUDIO_STREAM;
    }

    @Override
    public long getViewCount() {
        return -1L;
    }

    @Override
    public String getUploaderName() {
        return this.show.getString("title");
    }

    @Override
    public String getUploaderUrl() {
        return "";
    }

    @Override
    public boolean isUploaderVerified() throws ParsingException {
        return false;
    }

    @Override
    public boolean isAd() {
        return false;
    }
}

