/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.bandcamp.extractors;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.watermedia.shaded.com.grack.nanojson.JsonArray;
import org.watermedia.shaded.com.grack.nanojson.JsonObject;
import org.watermedia.shaded.com.grack.nanojson.JsonParser;
import org.watermedia.shaded.com.grack.nanojson.JsonParserException;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.javax.annotation.Nullable;
import org.watermedia.shaded.jsoup.Jsoup;
import org.watermedia.shaded.jsoup.nodes.Element;
import org.watermedia.shaded.schabi.newpipe.extractor.Image;
import org.watermedia.shaded.schabi.newpipe.extractor.MediaFormat;
import org.watermedia.shaded.schabi.newpipe.extractor.NewPipe;
import org.watermedia.shaded.schabi.newpipe.extractor.StreamingService;
import org.watermedia.shaded.schabi.newpipe.extractor.downloader.Downloader;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ContentNotSupportedException;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ExtractionException;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ReCaptchaException;
import org.watermedia.shaded.schabi.newpipe.extractor.linkhandler.LinkHandler;
import org.watermedia.shaded.schabi.newpipe.extractor.playlist.PlaylistInfoItemsCollector;
import org.watermedia.shaded.schabi.newpipe.extractor.services.bandcamp.extractors.BandcampExtractorHelper;
import org.watermedia.shaded.schabi.newpipe.extractor.services.bandcamp.extractors.BandcampStreamExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.AudioStream;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.Description;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.StreamSegment;

public class BandcampRadioStreamExtractor
extends BandcampStreamExtractor {
    private static final String OPUS_LO = "opus-lo";
    private static final String MP3_128 = "mp3-128";
    private JsonObject showInfo;

    public BandcampRadioStreamExtractor(StreamingService service, LinkHandler linkHandler) {
        super(service, linkHandler);
    }

    static JsonObject query(int id2) throws ParsingException {
        try {
            return JsonParser.object().from(NewPipe.getDownloader().get("https://bandcamp.com/api/bcweekly/1/get?id=" + id2).responseBody());
        }
        catch (IOException | JsonParserException | ReCaptchaException e) {
            throw new ParsingException("could not get show data", e);
        }
    }

    @Override
    public void onFetchPage(@Nonnull Downloader downloader) throws IOException, ExtractionException {
        this.showInfo = BandcampRadioStreamExtractor.query(Integer.parseInt(this.getId()));
    }

    @Override
    @Nonnull
    public String getName() throws ParsingException {
        return this.showInfo.getString("subtitle");
    }

    @Override
    @Nonnull
    public String getUploaderUrl() throws ContentNotSupportedException {
        throw new ContentNotSupportedException("Fan pages are not supported");
    }

    @Override
    @Nonnull
    public String getUrl() throws ParsingException {
        return this.getLinkHandler().getUrl();
    }

    @Override
    @Nonnull
    public String getUploaderName() throws ParsingException {
        return Jsoup.parse(this.showInfo.getString("image_caption")).getElementsByTag("a").stream().map(Element::text).findFirst().orElseThrow(() -> new ParsingException("Could not get uploader name"));
    }

    @Override
    @Nullable
    public String getTextualUploadDate() {
        return this.showInfo.getString("published_date");
    }

    @Override
    @Nonnull
    public List<Image> getThumbnails() throws ParsingException {
        return BandcampExtractorHelper.getImagesFromImageId(this.showInfo.getLong("show_image_id"), false);
    }

    @Override
    @Nonnull
    public List<Image> getUploaderAvatars() {
        return Collections.singletonList(new Image("https://bandcamp.com/img/buttons/bandcamp-button-circle-whitecolor-512.png", 512, 512, Image.ResolutionLevel.MEDIUM));
    }

    @Override
    @Nonnull
    public Description getDescription() {
        return new Description(this.showInfo.getString("desc"), 3);
    }

    @Override
    public long getLength() {
        return this.showInfo.getLong("audio_duration");
    }

    @Override
    public List<AudioStream> getAudioStreams() {
        ArrayList<AudioStream> audioStreams = new ArrayList<AudioStream>();
        JsonObject streams = this.showInfo.getObject("audio_stream");
        if (streams.has(MP3_128)) {
            audioStreams.add(new AudioStream.Builder().setId(MP3_128).setContent(streams.getString(MP3_128), true).setMediaFormat(MediaFormat.MP3).setAverageBitrate(128).build());
        }
        if (streams.has(OPUS_LO)) {
            audioStreams.add(new AudioStream.Builder().setId(OPUS_LO).setContent(streams.getString(OPUS_LO), true).setMediaFormat(MediaFormat.OPUS).setAverageBitrate(100).build());
        }
        return audioStreams;
    }

    @Override
    @Nonnull
    public List<StreamSegment> getStreamSegments() throws ParsingException {
        JsonArray tracks = this.showInfo.getArray("tracks");
        ArrayList<StreamSegment> segments = new ArrayList<StreamSegment>(tracks.size());
        for (Object t : tracks) {
            JsonObject track = (JsonObject)t;
            StreamSegment segment = new StreamSegment(track.getString("title"), track.getInt("timecode"));
            segment.setPreviewUrl(BandcampExtractorHelper.getImageUrl(track.getLong("track_art_id"), true));
            segment.setChannelName(track.getString("artist"));
            segments.add(segment);
        }
        return segments;
    }

    @Override
    @Nonnull
    public String getLicence() {
        return "";
    }

    @Override
    @Nonnull
    public String getCategory() {
        return "";
    }

    @Override
    @Nonnull
    public List<String> getTags() {
        return Collections.emptyList();
    }

    @Override
    public PlaylistInfoItemsCollector getRelatedItems() {
        return null;
    }
}

