/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.bandcamp.extractors;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.jsoup.Jsoup;
import org.watermedia.shaded.jsoup.nodes.Document;
import org.watermedia.shaded.jsoup.nodes.Element;
import org.watermedia.shaded.jsoup.select.Elements;
import org.watermedia.shaded.schabi.newpipe.extractor.InfoItem;
import org.watermedia.shaded.schabi.newpipe.extractor.ListExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.MetaInfo;
import org.watermedia.shaded.schabi.newpipe.extractor.MultiInfoItemsCollector;
import org.watermedia.shaded.schabi.newpipe.extractor.Page;
import org.watermedia.shaded.schabi.newpipe.extractor.StreamingService;
import org.watermedia.shaded.schabi.newpipe.extractor.downloader.Downloader;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ExtractionException;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.linkhandler.SearchQueryHandler;
import org.watermedia.shaded.schabi.newpipe.extractor.search.SearchExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.services.bandcamp.extractors.BandcampChannelInfoItemExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.services.bandcamp.extractors.BandcampPlaylistInfoItemExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.services.bandcamp.extractors.streaminfoitem.BandcampSearchStreamInfoItemExtractor;

public class BandcampSearchExtractor
extends SearchExtractor {
    public BandcampSearchExtractor(StreamingService service, SearchQueryHandler linkHandler) {
        super(service, linkHandler);
    }

    @Override
    @Nonnull
    public String getSearchSuggestion() {
        return "";
    }

    @Override
    public boolean isCorrectedSearch() {
        return false;
    }

    @Override
    @Nonnull
    public List<MetaInfo> getMetaInfo() throws ParsingException {
        return Collections.emptyList();
    }

    @Override
    public ListExtractor.InfoItemsPage<InfoItem> getPage(Page page) throws IOException, ExtractionException {
        MultiInfoItemsCollector collector = new MultiInfoItemsCollector(this.getServiceId());
        Document d = Jsoup.parse(this.getDownloader().get(page.getUrl()).responseBody());
        for (Element searchResult : d.getElementsByClass("searchresult")) {
            String type;
            switch (type = searchResult.getElementsByClass("result-info").stream().flatMap(element -> element.getElementsByClass("itemtype").stream()).map(Element::text).findFirst().orElse("")) {
                case "ARTIST": {
                    collector.commit(new BandcampChannelInfoItemExtractor(searchResult));
                    break;
                }
                case "ALBUM": {
                    collector.commit(new BandcampPlaylistInfoItemExtractor(searchResult));
                    break;
                }
                case "TRACK": {
                    collector.commit(new BandcampSearchStreamInfoItemExtractor(searchResult, null));
                    break;
                }
            }
        }
        Elements pageLists = d.getElementsByClass("pagelist");
        if (pageLists.isEmpty()) {
            return new ListExtractor.InfoItemsPage<InfoItem>(collector, null);
        }
        Elements pages = pageLists.stream().map(element -> element.getElementsByTag("li")).findFirst().orElseGet(Elements::new);
        int currentPage = -1;
        for (int i = 0; i < pages.size(); ++i) {
            Element pageElement = (Element)pages.get(i);
            if (pageElement.getElementsByTag("span").isEmpty()) continue;
            currentPage = i + 1;
            break;
        }
        String nextUrl = null;
        if (currentPage < pages.size()) {
            nextUrl = page.getUrl().substring(0, page.getUrl().length() - 1) + (currentPage + 1);
        }
        return new ListExtractor.InfoItemsPage<InfoItem>(collector, new Page(nextUrl));
    }

    @Override
    @Nonnull
    public ListExtractor.InfoItemsPage<InfoItem> getInitialPage() throws IOException, ExtractionException {
        return this.getPage(new Page(this.getUrl()));
    }

    @Override
    public void onFetchPage(@Nonnull Downloader downloader) throws IOException, ExtractionException {
    }
}

