/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.media_ccc.extractors;

import java.io.IOException;
import java.util.Objects;
import org.watermedia.shaded.com.grack.nanojson.JsonObject;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.javax.annotation.Nullable;
import org.watermedia.shaded.schabi.newpipe.extractor.InfoItem;
import org.watermedia.shaded.schabi.newpipe.extractor.ListExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.MultiInfoItemsCollector;
import org.watermedia.shaded.schabi.newpipe.extractor.Page;
import org.watermedia.shaded.schabi.newpipe.extractor.StreamingService;
import org.watermedia.shaded.schabi.newpipe.extractor.channel.tabs.ChannelTabExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.downloader.Downloader;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ExtractionException;
import org.watermedia.shaded.schabi.newpipe.extractor.linkhandler.ListLinkHandler;
import org.watermedia.shaded.schabi.newpipe.extractor.services.media_ccc.extractors.MediaCCCConferenceExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.services.media_ccc.extractors.infoItems.MediaCCCStreamInfoItemExtractor;

public class MediaCCCChannelTabExtractor
extends ChannelTabExtractor {
    @Nullable
    private JsonObject conferenceData;

    public MediaCCCChannelTabExtractor(StreamingService service, ListLinkHandler linkHandler, @Nullable JsonObject conferenceData) {
        super(service, linkHandler);
        this.conferenceData = conferenceData;
    }

    @Override
    public void onFetchPage(@Nonnull Downloader downloader) throws ExtractionException, IOException {
        if (this.conferenceData == null) {
            this.conferenceData = MediaCCCConferenceExtractor.fetchConferenceData(downloader, this.getId());
        }
    }

    @Override
    @Nonnull
    public ListExtractor.InfoItemsPage<InfoItem> getInitialPage() {
        MultiInfoItemsCollector collector = new MultiInfoItemsCollector(this.getServiceId());
        Objects.requireNonNull(this.conferenceData).getArray("events").stream().filter(JsonObject.class::isInstance).map(JsonObject.class::cast).forEach(event -> collector.commit(new MediaCCCStreamInfoItemExtractor((JsonObject)event)));
        return new ListExtractor.InfoItemsPage<InfoItem>(collector, null);
    }

    @Override
    public ListExtractor.InfoItemsPage<InfoItem> getPage(Page page) {
        return ListExtractor.InfoItemsPage.emptyPage();
    }
}

