/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.media_ccc.extractors;

import java.io.IOException;
import org.watermedia.shaded.com.grack.nanojson.JsonArray;
import org.watermedia.shaded.com.grack.nanojson.JsonObject;
import org.watermedia.shaded.com.grack.nanojson.JsonParser;
import org.watermedia.shaded.com.grack.nanojson.JsonParserException;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.schabi.newpipe.extractor.ListExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.Page;
import org.watermedia.shaded.schabi.newpipe.extractor.StreamingService;
import org.watermedia.shaded.schabi.newpipe.extractor.channel.ChannelInfoItem;
import org.watermedia.shaded.schabi.newpipe.extractor.channel.ChannelInfoItemsCollector;
import org.watermedia.shaded.schabi.newpipe.extractor.downloader.Downloader;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ExtractionException;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.kiosk.KioskExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.linkhandler.ListLinkHandler;
import org.watermedia.shaded.schabi.newpipe.extractor.services.media_ccc.extractors.infoItems.MediaCCCConferenceInfoItemExtractor;

public class MediaCCCConferenceKiosk
extends KioskExtractor<ChannelInfoItem> {
    public static final String KIOSK_ID = "conferences";
    private JsonObject doc;

    public MediaCCCConferenceKiosk(StreamingService streamingService, ListLinkHandler linkHandler, String kioskId) {
        super(streamingService, linkHandler, kioskId);
    }

    @Override
    @Nonnull
    public ListExtractor.InfoItemsPage<ChannelInfoItem> getInitialPage() {
        JsonArray conferences = this.doc.getArray(KIOSK_ID);
        ChannelInfoItemsCollector collector = new ChannelInfoItemsCollector(this.getServiceId());
        for (int i = 0; i < conferences.size(); ++i) {
            collector.commit(new MediaCCCConferenceInfoItemExtractor(conferences.getObject(i)));
        }
        return new ListExtractor.InfoItemsPage<ChannelInfoItem>(collector, null);
    }

    @Override
    public ListExtractor.InfoItemsPage<ChannelInfoItem> getPage(Page page) {
        return ListExtractor.InfoItemsPage.emptyPage();
    }

    @Override
    public void onFetchPage(@Nonnull Downloader downloader) throws IOException, ExtractionException {
        String site = downloader.get(this.getLinkHandler().getUrl(), this.getExtractorLocalization()).responseBody();
        try {
            this.doc = JsonParser.object().from(site);
        }
        catch (JsonParserException jpe) {
            throw new ExtractionException("Could not parse json.", jpe);
        }
    }

    @Override
    @Nonnull
    public String getName() throws ParsingException {
        return this.doc.getString("Conferences");
    }
}

