/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.peertube;

import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.watermedia.shaded.com.grack.nanojson.JsonArray;
import org.watermedia.shaded.com.grack.nanojson.JsonObject;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.schabi.newpipe.extractor.Image;
import org.watermedia.shaded.schabi.newpipe.extractor.InfoItemExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.InfoItemsCollector;
import org.watermedia.shaded.schabi.newpipe.extractor.Page;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ContentNotAvailableException;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.services.peertube.extractors.PeertubeChannelInfoItemExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.services.peertube.extractors.PeertubePlaylistInfoItemExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.services.peertube.extractors.PeertubeSepiaStreamInfoItemExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.services.peertube.extractors.PeertubeStreamInfoItemExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.JsonUtils;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.Parser;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.Utils;

public final class PeertubeParsingHelper {
    public static final String START_KEY = "start";
    public static final String COUNT_KEY = "count";
    public static final int ITEMS_PER_PAGE = 12;
    public static final String START_PATTERN = "start=(\\d*)";

    private PeertubeParsingHelper() {
    }

    public static void validate(JsonObject json) throws ContentNotAvailableException {
        String error = json.getString("error");
        if (!Utils.isBlank(error)) {
            throw new ContentNotAvailableException(error);
        }
    }

    public static OffsetDateTime parseDateFrom(String textualUploadDate) throws ParsingException {
        try {
            return OffsetDateTime.ofInstant(Instant.parse(textualUploadDate), ZoneOffset.UTC);
        }
        catch (DateTimeParseException e) {
            throw new ParsingException("Could not parse date: \"" + textualUploadDate + "\"", e);
        }
    }

    public static Page getNextPage(String prevPageUrl, long total) {
        long nextStart;
        String prevStart;
        try {
            prevStart = Parser.matchGroup1(START_PATTERN, prevPageUrl);
        }
        catch (Parser.RegexException e) {
            return null;
        }
        if (Utils.isBlank(prevStart)) {
            return null;
        }
        try {
            nextStart = Long.parseLong(prevStart) + 12L;
        }
        catch (NumberFormatException e) {
            return null;
        }
        if (nextStart >= total) {
            return null;
        }
        return new Page(prevPageUrl.replace("start=" + prevStart, "start=" + nextStart));
    }

    public static void collectItemsFrom(InfoItemsCollector collector, JsonObject json, String baseUrl) throws ParsingException {
        PeertubeParsingHelper.collectItemsFrom(collector, json, baseUrl, false);
    }

    public static void collectItemsFrom(InfoItemsCollector collector, JsonObject json, String baseUrl, boolean sepia) throws ParsingException {
        JsonArray contents;
        try {
            contents = (JsonArray)JsonUtils.getValue(json, "data");
        }
        catch (Exception e) {
            throw new ParsingException("Unable to extract list info", e);
        }
        for (Object c : contents) {
            if (!(c instanceof JsonObject)) continue;
            JsonObject item = (JsonObject)c;
            if (item.has("video")) {
                item = item.getObject("video");
            }
            boolean isPlaylistInfoItem = item.has("videosLength");
            boolean isChannelInfoItem = item.has("followersCount");
            InfoItemExtractor extractor = sepia ? new PeertubeSepiaStreamInfoItemExtractor(item, baseUrl) : (isPlaylistInfoItem ? new PeertubePlaylistInfoItemExtractor(item, baseUrl) : (isChannelInfoItem ? new PeertubeChannelInfoItemExtractor(item, baseUrl) : new PeertubeStreamInfoItemExtractor(item, baseUrl)));
            collector.commit(extractor);
        }
    }

    @Nonnull
    public static List<Image> getAvatarsFromOwnerAccountOrVideoChannelObject(@Nonnull String baseUrl, @Nonnull JsonObject ownerAccountOrVideoChannelObject) {
        return PeertubeParsingHelper.getImagesFromAvatarsOrBanners(baseUrl, ownerAccountOrVideoChannelObject, "avatars", "avatar");
    }

    @Nonnull
    public static List<Image> getBannersFromAccountOrVideoChannelObject(@Nonnull String baseUrl, @Nonnull JsonObject ownerAccountOrVideoChannelObject) {
        return PeertubeParsingHelper.getImagesFromAvatarsOrBanners(baseUrl, ownerAccountOrVideoChannelObject, "banners", "banner");
    }

    @Nonnull
    public static List<Image> getThumbnailsFromPlaylistOrVideoItem(@Nonnull String baseUrl, @Nonnull JsonObject playlistOrVideoItemObject) {
        String previewPath;
        ArrayList<Image> imageList = new ArrayList<Image>(2);
        String thumbnailPath = playlistOrVideoItemObject.getString("thumbnailPath");
        if (!Utils.isNullOrEmpty(thumbnailPath)) {
            imageList.add(new Image(baseUrl + thumbnailPath, -1, -1, Image.ResolutionLevel.LOW));
        }
        if (!Utils.isNullOrEmpty(previewPath = playlistOrVideoItemObject.getString("previewPath"))) {
            imageList.add(new Image(baseUrl + previewPath, -1, -1, Image.ResolutionLevel.MEDIUM));
        }
        return Collections.unmodifiableList(imageList);
    }

    @Nonnull
    private static List<Image> getImagesFromAvatarsOrBanners(@Nonnull String baseUrl, @Nonnull JsonObject ownerAccountOrVideoChannelObject, @Nonnull String jsonArrayName, @Nonnull String jsonObjectName) {
        JsonArray images = ownerAccountOrVideoChannelObject.getArray(jsonArrayName);
        if (!Utils.isNullOrEmpty(images)) {
            return PeertubeParsingHelper.getImagesFromAvatarOrBannerArray(baseUrl, images);
        }
        JsonObject image = ownerAccountOrVideoChannelObject.getObject(jsonObjectName);
        String path = image.getString("path");
        if (!Utils.isNullOrEmpty(path)) {
            return List.of(new Image(baseUrl + path, -1, image.getInt("width", -1), Image.ResolutionLevel.UNKNOWN));
        }
        return List.of();
    }

    @Nonnull
    private static List<Image> getImagesFromAvatarOrBannerArray(@Nonnull String baseUrl, @Nonnull JsonArray avatarsOrBannersArray) {
        return avatarsOrBannersArray.stream().filter(JsonObject.class::isInstance).map(JsonObject.class::cast).filter(image -> !Utils.isNullOrEmpty(image.getString("path"))).map(image -> new Image(baseUrl + image.getString("path"), -1, image.getInt("width", -1), Image.ResolutionLevel.UNKNOWN)).collect(Collectors.toUnmodifiableList());
    }
}

