/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.peertube.extractors;

import java.io.IOException;
import java.util.List;
import org.watermedia.shaded.com.grack.nanojson.JsonObject;
import org.watermedia.shaded.com.grack.nanojson.JsonParser;
import org.watermedia.shaded.com.grack.nanojson.JsonParserException;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.javax.annotation.Nullable;
import org.watermedia.shaded.schabi.newpipe.extractor.Image;
import org.watermedia.shaded.schabi.newpipe.extractor.StreamingService;
import org.watermedia.shaded.schabi.newpipe.extractor.channel.ChannelExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.downloader.Downloader;
import org.watermedia.shaded.schabi.newpipe.extractor.downloader.Response;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ExtractionException;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.linkhandler.ListLinkHandler;
import org.watermedia.shaded.schabi.newpipe.extractor.services.peertube.PeertubeParsingHelper;
import org.watermedia.shaded.schabi.newpipe.extractor.services.peertube.linkHandler.PeertubeChannelTabLinkHandlerFactory;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.JsonUtils;

public class PeertubeChannelExtractor
extends ChannelExtractor {
    private JsonObject json;
    private final String baseUrl = this.getBaseUrl();

    public PeertubeChannelExtractor(StreamingService service, ListLinkHandler linkHandler) throws ParsingException {
        super(service, linkHandler);
    }

    @Override
    @Nonnull
    public List<Image> getAvatars() {
        return PeertubeParsingHelper.getAvatarsFromOwnerAccountOrVideoChannelObject(this.baseUrl, this.json);
    }

    @Override
    @Nonnull
    public List<Image> getBanners() {
        return PeertubeParsingHelper.getBannersFromAccountOrVideoChannelObject(this.baseUrl, this.json);
    }

    @Override
    public String getFeedUrl() throws ParsingException {
        return this.getBaseUrl() + "/feeds/videos.xml?videoChannelId=" + this.json.get("id");
    }

    @Override
    public long getSubscriberCount() {
        return this.json.getLong("followersCount");
    }

    @Override
    @Nullable
    public String getDescription() {
        return this.json.getString("description");
    }

    @Override
    public String getParentChannelName() throws ParsingException {
        return JsonUtils.getString(this.json, "ownerAccount.name");
    }

    @Override
    public String getParentChannelUrl() throws ParsingException {
        return JsonUtils.getString(this.json, "ownerAccount.url");
    }

    @Override
    @Nonnull
    public List<Image> getParentChannelAvatars() {
        return PeertubeParsingHelper.getAvatarsFromOwnerAccountOrVideoChannelObject(this.baseUrl, this.json.getObject("ownerAccount"));
    }

    @Override
    public boolean isVerified() throws ParsingException {
        return false;
    }

    @Override
    @Nonnull
    public List<ListLinkHandler> getTabs() throws ParsingException {
        return List.of(PeertubeChannelTabLinkHandlerFactory.getInstance().fromQuery(this.getId(), List.of("videos"), "", this.getBaseUrl()), PeertubeChannelTabLinkHandlerFactory.getInstance().fromQuery(this.getId(), List.of("playlists"), "", this.getBaseUrl()));
    }

    @Override
    public void onFetchPage(@Nonnull Downloader downloader) throws IOException, ExtractionException {
        Response response = downloader.get(this.baseUrl + "/api/v1/" + this.getId());
        if (response == null) {
            throw new ExtractionException("Unable to extract PeerTube channel data");
        }
        this.setInitialData(response.responseBody());
    }

    private void setInitialData(String responseBody) throws ExtractionException {
        try {
            this.json = JsonParser.object().from(responseBody);
        }
        catch (JsonParserException e) {
            throw new ExtractionException("Unable to extract PeerTube channel data", e);
        }
        if (this.json == null) {
            throw new ExtractionException("Unable to extract PeerTube channel data");
        }
    }

    @Override
    @Nonnull
    public String getName() throws ParsingException {
        return JsonUtils.getString(this.json, "displayName");
    }
}

