/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.peertube.extractors;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.watermedia.shaded.com.grack.nanojson.JsonArray;
import org.watermedia.shaded.com.grack.nanojson.JsonObject;
import org.watermedia.shaded.com.grack.nanojson.JsonParser;
import org.watermedia.shaded.com.grack.nanojson.JsonParserException;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.schabi.newpipe.extractor.ListExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.Page;
import org.watermedia.shaded.schabi.newpipe.extractor.StreamingService;
import org.watermedia.shaded.schabi.newpipe.extractor.comments.CommentsExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.comments.CommentsInfoItem;
import org.watermedia.shaded.schabi.newpipe.extractor.comments.CommentsInfoItemsCollector;
import org.watermedia.shaded.schabi.newpipe.extractor.downloader.Downloader;
import org.watermedia.shaded.schabi.newpipe.extractor.downloader.Response;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ExtractionException;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.linkhandler.ListLinkHandler;
import org.watermedia.shaded.schabi.newpipe.extractor.services.peertube.PeertubeParsingHelper;
import org.watermedia.shaded.schabi.newpipe.extractor.services.peertube.extractors.PeertubeCommentsInfoItemExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.Utils;

public class PeertubeCommentsExtractor
extends CommentsExtractor {
    static final String CHILDREN = "children";
    private static final String IS_DELETED = "isDeleted";
    private static final String TOTAL = "total";
    private Boolean isReply = null;

    public PeertubeCommentsExtractor(StreamingService service, ListLinkHandler uiHandler) {
        super(service, uiHandler);
    }

    @Override
    @Nonnull
    public ListExtractor.InfoItemsPage<CommentsInfoItem> getInitialPage() throws IOException, ExtractionException {
        if (this.isReply()) {
            return this.getPage(new Page(this.getOriginalUrl()));
        }
        return this.getPage(new Page(this.getUrl() + "?start=0&count=12"));
    }

    private boolean isReply() throws ParsingException {
        if (this.isReply == null) {
            this.isReply = this.getOriginalUrl().contains("/videos/watch/") ? Boolean.valueOf(false) : Boolean.valueOf(this.getOriginalUrl().contains("/org/watermedia/shaded/comment-threads/"));
        }
        return this.isReply;
    }

    private void collectCommentsFrom(@Nonnull CommentsInfoItemsCollector collector, @Nonnull JsonObject json) throws ParsingException {
        JsonArray contents = json.getArray("data");
        for (Object c : contents) {
            JsonObject item;
            if (!(c instanceof JsonObject) || (item = (JsonObject)c).getBoolean(IS_DELETED)) continue;
            collector.commit(new PeertubeCommentsInfoItemExtractor(item, null, this.getUrl(), this.getBaseUrl(), this.isReply()));
        }
    }

    private void collectRepliesFrom(@Nonnull CommentsInfoItemsCollector collector, @Nonnull JsonObject json) throws ParsingException {
        JsonArray contents = json.getArray(CHILDREN);
        for (Object c : contents) {
            if (!(c instanceof JsonObject)) continue;
            JsonObject content = (JsonObject)c;
            JsonObject item = content.getObject("org.watermedia.shaded.comment");
            JsonArray children = content.getArray(CHILDREN);
            if (item.getBoolean(IS_DELETED)) continue;
            collector.commit(new PeertubeCommentsInfoItemExtractor(item, children, this.getUrl(), this.getBaseUrl(), this.isReply()));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ListExtractor.InfoItemsPage<CommentsInfoItem> getPage(Page page) throws IOException, ExtractionException {
        long total;
        if (page == null || Utils.isNullOrEmpty(page.getUrl())) {
            throw new IllegalArgumentException("Page doesn't contain an URL");
        }
        JsonObject json = null;
        CommentsInfoItemsCollector collector = new CommentsInfoItemsCollector(this.getServiceId());
        if (page.getBody() == null) {
            Response response = this.getDownloader().get(page.getUrl());
            if (response != null && !Utils.isBlank(response.responseBody())) {
                try {
                    json = JsonParser.object().from(response.responseBody());
                }
                catch (Exception e) {
                    throw new ParsingException("Could not parse json data for comments info", e);
                }
            }
            if (json == null) throw new ExtractionException("Unable to get PeerTube kiosk info");
            PeertubeParsingHelper.validate(json);
            if (this.isReply() || json.has(CHILDREN)) {
                total = json.getArray(CHILDREN).size();
                this.collectRepliesFrom(collector, json);
                return new ListExtractor.InfoItemsPage<CommentsInfoItem>(collector, PeertubeParsingHelper.getNextPage(page.getUrl(), total));
            } else {
                total = json.getLong(TOTAL);
                this.collectCommentsFrom(collector, json);
            }
            return new ListExtractor.InfoItemsPage<CommentsInfoItem>(collector, PeertubeParsingHelper.getNextPage(page.getUrl(), total));
        }
        try {
            json = JsonParser.object().from(new String(page.getBody(), StandardCharsets.UTF_8));
            this.isReply = true;
            total = json.getArray(CHILDREN).size();
            this.collectRepliesFrom(collector, json);
            return new ListExtractor.InfoItemsPage<CommentsInfoItem>(collector, PeertubeParsingHelper.getNextPage(page.getUrl(), total));
        }
        catch (JsonParserException e) {
            throw new ParsingException("Could not parse json data for nested comments  info", e);
        }
    }

    @Override
    public void onFetchPage(@Nonnull Downloader downloader) {
    }
}

