/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.soundcloud;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.watermedia.shaded.com.grack.nanojson.JsonArray;
import org.watermedia.shaded.com.grack.nanojson.JsonObject;
import org.watermedia.shaded.com.grack.nanojson.JsonParser;
import org.watermedia.shaded.com.grack.nanojson.JsonParserException;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.javax.annotation.Nullable;
import org.watermedia.shaded.jsoup.Jsoup;
import org.watermedia.shaded.jsoup.nodes.Document;
import org.watermedia.shaded.jsoup.nodes.Element;
import org.watermedia.shaded.jsoup.select.Elements;
import org.watermedia.shaded.schabi.newpipe.extractor.Image;
import org.watermedia.shaded.schabi.newpipe.extractor.MultiInfoItemsCollector;
import org.watermedia.shaded.schabi.newpipe.extractor.NewPipe;
import org.watermedia.shaded.schabi.newpipe.extractor.ServiceList;
import org.watermedia.shaded.schabi.newpipe.extractor.channel.ChannelInfoItemsCollector;
import org.watermedia.shaded.schabi.newpipe.extractor.downloader.Downloader;
import org.watermedia.shaded.schabi.newpipe.extractor.downloader.Response;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ExtractionException;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ReCaptchaException;
import org.watermedia.shaded.schabi.newpipe.extractor.services.soundcloud.extractors.SoundcloudChannelInfoItemExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.services.soundcloud.extractors.SoundcloudLikesInfoItemExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.services.soundcloud.extractors.SoundcloudPlaylistInfoItemExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.services.soundcloud.extractors.SoundcloudStreamInfoItemExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.StreamInfoItemsCollector;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.ImageSuffix;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.JsonUtils;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.Parser;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.Utils;

public final class SoundcloudParsingHelper {
    private static final List<ImageSuffix> ALBUMS_AND_ARTWORKS_IMAGE_SUFFIXES = List.of(new ImageSuffix("mini", 16, 16, Image.ResolutionLevel.LOW), new ImageSuffix("t20x20", 20, 20, Image.ResolutionLevel.LOW), new ImageSuffix("small", 32, 32, Image.ResolutionLevel.LOW), new ImageSuffix("badge", 47, 47, Image.ResolutionLevel.LOW), new ImageSuffix("t50x50", 50, 50, Image.ResolutionLevel.LOW), new ImageSuffix("t60x60", 60, 60, Image.ResolutionLevel.LOW), new ImageSuffix("t67x67", 67, 67, Image.ResolutionLevel.LOW), new ImageSuffix("t80x80", 80, 80, Image.ResolutionLevel.LOW), new ImageSuffix("large", 100, 100, Image.ResolutionLevel.LOW), new ImageSuffix("t120x120", 120, 120, Image.ResolutionLevel.LOW), new ImageSuffix("t200x200", 200, 200, Image.ResolutionLevel.MEDIUM), new ImageSuffix("t240x240", 240, 240, Image.ResolutionLevel.MEDIUM), new ImageSuffix("t250x250", 250, 250, Image.ResolutionLevel.MEDIUM), new ImageSuffix("t300x300", 300, 300, Image.ResolutionLevel.MEDIUM), new ImageSuffix("t500x500", 500, 500, Image.ResolutionLevel.MEDIUM));
    private static final List<ImageSuffix> VISUALS_IMAGE_SUFFIXES = List.of(new ImageSuffix("t1240x260", 1240, 260, Image.ResolutionLevel.MEDIUM), new ImageSuffix("t2480x520", 2480, 520, Image.ResolutionLevel.MEDIUM));
    private static String clientId;
    public static final String SOUNDCLOUD_API_V2_URL = "https://api-v2.soundcloud.com/";
    private static final Pattern ON_URL_PATTERN;

    private SoundcloudParsingHelper() {
    }

    public static synchronized String clientId() throws ExtractionException, IOException {
        if (!Utils.isNullOrEmpty(clientId)) {
            return clientId;
        }
        Downloader dl = NewPipe.getDownloader();
        Response download = dl.get("https://soundcloud.com");
        String responseBody = download.responseBody();
        String clientIdPattern = ",client_id:\"(.*?)\"";
        Document doc = Jsoup.parse(responseBody);
        Elements possibleScripts = doc.select("script[src*=\"sndcdn.com/assets/\"][src$=\".js\"]");
        Collections.reverse(possibleScripts);
        Map<String, List<String>> headers = Map.of("Range", List.of("bytes=0-50000"));
        for (Element element : possibleScripts) {
            String srcUrl = element.attr("src");
            if (Utils.isNullOrEmpty(srcUrl)) continue;
            try {
                clientId = Parser.matchGroup1(",client_id:\"(.*?)\"", dl.get(srcUrl, headers).responseBody());
                return clientId;
            }
            catch (Parser.RegexException regexException) {
            }
        }
        throw new ExtractionException("Couldn't extract client id");
    }

    public static OffsetDateTime parseDateFrom(String textualUploadDate) throws ParsingException {
        try {
            return OffsetDateTime.parse(textualUploadDate);
        }
        catch (DateTimeParseException e1) {
            try {
                return OffsetDateTime.parse(textualUploadDate, DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm:ss +0000"));
            }
            catch (DateTimeParseException e2) {
                throw new ParsingException("Could not parse date: \"" + textualUploadDate + "\", " + e1.getMessage(), e2);
            }
        }
    }

    public static JsonObject resolveFor(@Nonnull Downloader downloader, String url) throws IOException, ExtractionException {
        String apiUrl = "https://api-v2.soundcloud.com/resolve?url=" + Utils.encodeUrlUtf8(url) + "&client_id=" + SoundcloudParsingHelper.clientId();
        try {
            String response = downloader.get(apiUrl, ServiceList.SoundCloud.getLocalization()).responseBody();
            return JsonParser.object().from(response);
        }
        catch (JsonParserException e) {
            throw new ParsingException("Could not parse json response", e);
        }
    }

    public static String resolveUrlWithEmbedPlayer(String apiUrl) throws IOException, ReCaptchaException {
        String response = NewPipe.getDownloader().get("https://w.soundcloud.com/player/?url=" + Utils.encodeUrlUtf8(apiUrl), ServiceList.SoundCloud.getLocalization()).responseBody();
        return Jsoup.parse(response).select("link[rel=\"canonical\"]").first().attr("abs:href");
    }

    public static String resolveIdWithWidgetApi(String urlString) throws IOException, ParsingException {
        URL url;
        String fixedUrl = urlString;
        if (ON_URL_PATTERN.matcher(fixedUrl).find()) {
            try {
                fixedUrl = NewPipe.getDownloader().head(fixedUrl).latestUrl();
                fixedUrl = fixedUrl.split("\\?")[0];
            }
            catch (ExtractionException e) {
                throw new ParsingException("Could not follow on.soundcloud.com redirect", e);
            }
        }
        if (fixedUrl.charAt(fixedUrl.length() - 1) == '/') {
            fixedUrl = fixedUrl.substring(0, fixedUrl.length() - 1);
        }
        fixedUrl = Utils.removeMAndWWWFromUrl(fixedUrl.toLowerCase());
        try {
            url = Utils.stringToURL(fixedUrl);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("The given URL is not valid");
        }
        try {
            String widgetUrl = "https://api-widget.soundcloud.com/resolve?url=" + Utils.encodeUrlUtf8(url.toString()) + "&format=json&client_id=" + SoundcloudParsingHelper.clientId();
            String response = NewPipe.getDownloader().get(widgetUrl, ServiceList.SoundCloud.getLocalization()).responseBody();
            JsonObject o = JsonParser.object().from(response);
            return String.valueOf(JsonUtils.getValue(o, "id"));
        }
        catch (JsonParserException e) {
            throw new ParsingException("Could not parse JSON response", e);
        }
        catch (ExtractionException e) {
            throw new ParsingException("Could not resolve id with embedded player. ClientId not extracted", e);
        }
    }

    public static String getUsersFromApiMinItems(int minItems, ChannelInfoItemsCollector collector, String apiUrl) throws IOException, ReCaptchaException, ParsingException {
        String nextPageUrl = SoundcloudParsingHelper.getUsersFromApi(collector, apiUrl);
        while (!nextPageUrl.isEmpty() && collector.getItems().size() < minItems) {
            nextPageUrl = SoundcloudParsingHelper.getUsersFromApi(collector, nextPageUrl);
        }
        return nextPageUrl;
    }

    @Nonnull
    public static String getUsersFromApi(ChannelInfoItemsCollector collector, String apiUrl) throws IOException, ReCaptchaException, ParsingException {
        JsonObject responseObject;
        String response = NewPipe.getDownloader().get(apiUrl, ServiceList.SoundCloud.getLocalization()).responseBody();
        try {
            responseObject = JsonParser.object().from(response);
        }
        catch (JsonParserException e) {
            throw new ParsingException("Could not parse json response", e);
        }
        JsonArray responseCollection = responseObject.getArray("collection");
        for (Object o : responseCollection) {
            if (!(o instanceof JsonObject)) continue;
            JsonObject object = (JsonObject)o;
            collector.commit(new SoundcloudChannelInfoItemExtractor(object));
        }
        return SoundcloudParsingHelper.getNextPageUrl(responseObject);
    }

    public static String getStreamsFromApiMinItems(int minItems, StreamInfoItemsCollector collector, String apiUrl) throws IOException, ReCaptchaException, ParsingException {
        String nextPageUrl = SoundcloudParsingHelper.getStreamsFromApi(collector, apiUrl);
        while (!nextPageUrl.isEmpty() && collector.getItems().size() < minItems) {
            nextPageUrl = SoundcloudParsingHelper.getStreamsFromApi(collector, nextPageUrl);
        }
        return nextPageUrl;
    }

    @Nonnull
    public static String getStreamsFromApi(StreamInfoItemsCollector collector, String apiUrl, boolean charts) throws IOException, ReCaptchaException, ParsingException {
        JsonObject responseObject;
        Response response = NewPipe.getDownloader().get(apiUrl, ServiceList.SoundCloud.getLocalization());
        if (response.responseCode() >= 400) {
            throw new IOException("Could not get streams from API, HTTP " + response.responseCode());
        }
        try {
            responseObject = JsonParser.object().from(response.responseBody());
        }
        catch (JsonParserException e) {
            throw new ParsingException("Could not parse json response", e);
        }
        JsonArray responseCollection = responseObject.getArray("collection");
        for (Object o : responseCollection) {
            if (!(o instanceof JsonObject)) continue;
            JsonObject object = (JsonObject)o;
            collector.commit(new SoundcloudStreamInfoItemExtractor(charts ? object.getObject("track") : object));
        }
        return SoundcloudParsingHelper.getNextPageUrl(responseObject);
    }

    @Nonnull
    private static String getNextPageUrl(@Nonnull JsonObject response) {
        try {
            Object nextPageUrl = response.getString("next_href");
            if (!((String)nextPageUrl).contains("client_id=")) {
                nextPageUrl = (String)nextPageUrl + "&client_id=" + SoundcloudParsingHelper.clientId();
            }
            return nextPageUrl;
        }
        catch (Exception ignored) {
            return "";
        }
    }

    public static String getStreamsFromApi(StreamInfoItemsCollector collector, String apiUrl) throws ReCaptchaException, ParsingException, IOException {
        return SoundcloudParsingHelper.getStreamsFromApi(collector, apiUrl, false);
    }

    public static String getInfoItemsFromApi(MultiInfoItemsCollector collector, String apiUrl) throws ReCaptchaException, ParsingException, IOException {
        Object nextPageUrl;
        JsonObject responseObject;
        Response response = NewPipe.getDownloader().get(apiUrl, ServiceList.SoundCloud.getLocalization());
        if (response.responseCode() >= 400) {
            throw new IOException("Could not get streams from API, HTTP " + response.responseCode());
        }
        try {
            responseObject = JsonParser.object().from(response.responseBody());
        }
        catch (JsonParserException e) {
            throw new ParsingException("Could not parse json response", e);
        }
        responseObject.getArray("collection").stream().filter(JsonObject.class::isInstance).map(JsonObject.class::cast).forEach(searchResult -> {
            String kind;
            switch (kind = searchResult.getString("kind", "")) {
                case "user": {
                    collector.commit(new SoundcloudChannelInfoItemExtractor((JsonObject)searchResult));
                    break;
                }
                case "track": {
                    collector.commit(new SoundcloudStreamInfoItemExtractor((JsonObject)searchResult));
                    break;
                }
                case "playlist": {
                    collector.commit(new SoundcloudPlaylistInfoItemExtractor((JsonObject)searchResult));
                    break;
                }
                case "like": {
                    JsonObject likedPlaylist = searchResult.getObject("playlist", null);
                    collector.commit(likedPlaylist == null ? new SoundcloudLikesInfoItemExtractor((JsonObject)searchResult) : new SoundcloudPlaylistInfoItemExtractor(likedPlaylist));
                }
            }
        });
        try {
            nextPageUrl = responseObject.getString("next_href");
            if (!((String)nextPageUrl).contains("client_id=")) {
                nextPageUrl = (String)nextPageUrl + "&client_id=" + SoundcloudParsingHelper.clientId();
            }
        }
        catch (Exception ignored) {
            nextPageUrl = "";
        }
        return nextPageUrl;
    }

    @Nonnull
    public static String getUploaderUrl(JsonObject object) {
        String url = object.getObject("user").getString("permalink_url", "");
        return Utils.replaceHttpWithHttps(url);
    }

    @Nonnull
    public static String getAvatarUrl(JsonObject object) {
        String url = object.getObject("user").getString("avatar_url", "");
        return Utils.replaceHttpWithHttps(url);
    }

    @Nonnull
    public static String getUploaderName(JsonObject object) {
        return object.getObject("user").getString("username", "");
    }

    @Nonnull
    public static List<Image> getAllImagesFromTrackObject(@Nonnull JsonObject trackObject) throws ParsingException {
        String artworkUrl = trackObject.getString("artwork_url");
        if (artworkUrl != null) {
            return SoundcloudParsingHelper.getAllImagesFromArtworkOrAvatarUrl(artworkUrl);
        }
        String avatarUrl = trackObject.getObject("user").getString("avatar_url");
        if (avatarUrl != null) {
            return SoundcloudParsingHelper.getAllImagesFromArtworkOrAvatarUrl(avatarUrl);
        }
        throw new ParsingException("Could not get track or track user's thumbnails");
    }

    @Nonnull
    public static List<Image> getAllImagesFromArtworkOrAvatarUrl(@Nullable String originalArtworkOrAvatarUrl) {
        if (Utils.isNullOrEmpty(originalArtworkOrAvatarUrl)) {
            return List.of();
        }
        return SoundcloudParsingHelper.getAllImagesFromImageUrlReturned(originalArtworkOrAvatarUrl.replace("-large.", "-%s."), ALBUMS_AND_ARTWORKS_IMAGE_SUFFIXES);
    }

    @Nonnull
    public static List<Image> getAllImagesFromVisualUrl(@Nullable String originalVisualUrl) {
        if (Utils.isNullOrEmpty(originalVisualUrl)) {
            return List.of();
        }
        return SoundcloudParsingHelper.getAllImagesFromImageUrlReturned(originalVisualUrl.replace("-original.", "-%s."), VISUALS_IMAGE_SUFFIXES);
    }

    private static List<Image> getAllImagesFromImageUrlReturned(@Nonnull String baseImageUrlFormat, @Nonnull List<ImageSuffix> imageSuffixes) {
        return imageSuffixes.stream().map(imageSuffix -> new Image(String.format(baseImageUrlFormat, imageSuffix.getSuffix()), imageSuffix.getHeight(), imageSuffix.getWidth(), imageSuffix.getResolutionLevel())).collect(Collectors.toUnmodifiableList());
    }

    static {
        ON_URL_PATTERN = Pattern.compile("^https?://on.soundcloud.com/[0-9a-zA-Z]+$");
    }
}

