/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.soundcloud.extractors;

import java.io.IOException;
import java.util.List;
import org.watermedia.shaded.com.grack.nanojson.JsonObject;
import org.watermedia.shaded.com.grack.nanojson.JsonParser;
import org.watermedia.shaded.com.grack.nanojson.JsonParserException;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.schabi.newpipe.extractor.Image;
import org.watermedia.shaded.schabi.newpipe.extractor.StreamingService;
import org.watermedia.shaded.schabi.newpipe.extractor.channel.ChannelExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.downloader.Downloader;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ExtractionException;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.linkhandler.ListLinkHandler;
import org.watermedia.shaded.schabi.newpipe.extractor.services.soundcloud.SoundcloudParsingHelper;
import org.watermedia.shaded.schabi.newpipe.extractor.services.soundcloud.linkHandler.SoundcloudChannelTabLinkHandlerFactory;

public class SoundcloudChannelExtractor
extends ChannelExtractor {
    private String userId;
    private JsonObject user;
    private static final String USERS_ENDPOINT = "https://api-v2.soundcloud.com/users/";

    public SoundcloudChannelExtractor(StreamingService service, ListLinkHandler linkHandler) {
        super(service, linkHandler);
    }

    @Override
    public void onFetchPage(@Nonnull Downloader downloader) throws IOException, ExtractionException {
        this.userId = this.getLinkHandler().getId();
        String apiUrl = USERS_ENDPOINT + this.userId + "?client_id=" + SoundcloudParsingHelper.clientId();
        String response = downloader.get(apiUrl, this.getExtractorLocalization()).responseBody();
        try {
            this.user = JsonParser.object().from(response);
        }
        catch (JsonParserException e) {
            throw new ParsingException("Could not parse json response", e);
        }
    }

    @Override
    @Nonnull
    public String getId() {
        return this.userId;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.user.getString("username");
    }

    @Override
    @Nonnull
    public List<Image> getAvatars() {
        return SoundcloudParsingHelper.getAllImagesFromArtworkOrAvatarUrl(this.user.getString("avatar_url"));
    }

    @Override
    @Nonnull
    public List<Image> getBanners() {
        return SoundcloudParsingHelper.getAllImagesFromVisualUrl(this.user.getObject("visuals").getArray("visuals").getObject(0).getString("visual_url"));
    }

    @Override
    public String getFeedUrl() {
        return null;
    }

    @Override
    public long getSubscriberCount() {
        return this.user.getLong("followers_count", 0L);
    }

    @Override
    public String getDescription() {
        return this.user.getString("description", "");
    }

    @Override
    public String getParentChannelName() {
        return "";
    }

    @Override
    public String getParentChannelUrl() {
        return "";
    }

    @Override
    @Nonnull
    public List<Image> getParentChannelAvatars() {
        return List.of();
    }

    @Override
    public boolean isVerified() throws ParsingException {
        return this.user.getBoolean("verified");
    }

    @Override
    @Nonnull
    public List<ListLinkHandler> getTabs() throws ParsingException {
        String url = this.getUrl();
        String urlTracks = url + SoundcloudChannelTabLinkHandlerFactory.getUrlSuffix("tracks");
        String urlPlaylists = url + SoundcloudChannelTabLinkHandlerFactory.getUrlSuffix("playlists");
        String urlAlbums = url + SoundcloudChannelTabLinkHandlerFactory.getUrlSuffix("albums");
        String urlLikes = url + SoundcloudChannelTabLinkHandlerFactory.getUrlSuffix("likes");
        String id2 = this.getId();
        return List.of(new ListLinkHandler(urlTracks, urlTracks, id2, List.of("tracks"), ""), new ListLinkHandler(urlPlaylists, urlPlaylists, id2, List.of("playlists"), ""), new ListLinkHandler(urlAlbums, urlAlbums, id2, List.of("albums"), ""), new ListLinkHandler(urlLikes, urlLikes, id2, List.of("likes"), ""));
    }
}

