/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.soundcloud.extractors;

import java.io.IOException;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.schabi.newpipe.extractor.ListExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.Page;
import org.watermedia.shaded.schabi.newpipe.extractor.ServiceList;
import org.watermedia.shaded.schabi.newpipe.extractor.StreamingService;
import org.watermedia.shaded.schabi.newpipe.extractor.downloader.Downloader;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ExtractionException;
import org.watermedia.shaded.schabi.newpipe.extractor.kiosk.KioskExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.linkhandler.ListLinkHandler;
import org.watermedia.shaded.schabi.newpipe.extractor.localization.ContentCountry;
import org.watermedia.shaded.schabi.newpipe.extractor.services.soundcloud.SoundcloudParsingHelper;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.StreamInfoItem;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.StreamInfoItemsCollector;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.Utils;

public class SoundcloudChartsExtractor
extends KioskExtractor<StreamInfoItem> {
    private String initialFetchNextPageUrl;
    private StreamInfoItemsCollector initialFetchCollector;

    public SoundcloudChartsExtractor(StreamingService service, ListLinkHandler linkHandler, String kioskId) {
        super(service, linkHandler, kioskId);
    }

    @Override
    public void onFetchPage(@Nonnull Downloader downloader) throws ExtractionException, IOException {
        if (this.initialFetchNextPageUrl != null) {
            return;
        }
        this.initialFetchCollector = new StreamInfoItemsCollector(this.getServiceId());
        String apiUrl = "https://api-v2.soundcloud.com/charts?genre=soundcloud:genres:all-music&client_id=" + SoundcloudParsingHelper.clientId() + "&kind=trending";
        ContentCountry contentCountry = ServiceList.SoundCloud.getContentCountry();
        String apiUrlWithRegion = null;
        if (this.getService().getSupportedCountries().contains(contentCountry)) {
            apiUrlWithRegion = apiUrl + "&region=soundcloud:regions:" + contentCountry.getCountryCode();
        }
        try {
            this.initialFetchNextPageUrl = SoundcloudParsingHelper.getStreamsFromApi(this.initialFetchCollector, apiUrlWithRegion == null ? apiUrl : apiUrlWithRegion, true);
        }
        catch (IOException e) {
            this.initialFetchNextPageUrl = SoundcloudParsingHelper.getStreamsFromApi(this.initialFetchCollector, apiUrl, true);
        }
    }

    @Override
    @Nonnull
    public String getName() {
        return this.getId();
    }

    @Override
    public ListExtractor.InfoItemsPage<StreamInfoItem> getPage(Page page) throws IOException, ExtractionException {
        if (page == null || Utils.isNullOrEmpty(page.getUrl())) {
            throw new IllegalArgumentException("Page doesn't contain an URL");
        }
        StreamInfoItemsCollector collector = new StreamInfoItemsCollector(this.getServiceId());
        String nextPageUrl = SoundcloudParsingHelper.getStreamsFromApi(collector, page.getUrl(), true);
        return new ListExtractor.InfoItemsPage<StreamInfoItem>(collector, new Page(nextPageUrl));
    }

    @Override
    @Nonnull
    public ListExtractor.InfoItemsPage<StreamInfoItem> getInitialPage() throws IOException, ExtractionException {
        return new ListExtractor.InfoItemsPage<StreamInfoItem>(this.initialFetchCollector, new Page(this.initialFetchNextPageUrl));
    }
}

