/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.soundcloud.extractors;

import java.util.List;
import org.watermedia.shaded.com.grack.nanojson.JsonObject;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.schabi.newpipe.extractor.Image;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.playlist.PlaylistInfoItemExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.services.soundcloud.SoundcloudParsingHelper;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.Utils;

public class SoundcloudPlaylistInfoItemExtractor
implements PlaylistInfoItemExtractor {
    private static final String USER_KEY = "user";
    private static final String AVATAR_URL_KEY = "avatar_url";
    private static final String ARTWORK_URL_KEY = "artwork_url";
    private final JsonObject itemObject;

    public SoundcloudPlaylistInfoItemExtractor(JsonObject itemObject) {
        this.itemObject = itemObject;
    }

    @Override
    public String getName() {
        return this.itemObject.getString("title");
    }

    @Override
    public String getUrl() {
        return Utils.replaceHttpWithHttps(this.itemObject.getString("permalink_url"));
    }

    @Override
    @Nonnull
    public List<Image> getThumbnails() throws ParsingException {
        Object artworkUrl22;
        if (this.itemObject.isString(ARTWORK_URL_KEY) && !Utils.isNullOrEmpty((String)(artworkUrl22 = this.itemObject.getString(ARTWORK_URL_KEY)))) {
            return SoundcloudParsingHelper.getAllImagesFromArtworkOrAvatarUrl((String)artworkUrl22);
        }
        try {
            for (Object track : this.itemObject.getArray("tracks")) {
                String artworkUrl;
                JsonObject trackObject = (JsonObject)track;
                if (trackObject.isString(ARTWORK_URL_KEY) && !Utils.isNullOrEmpty(artworkUrl = trackObject.getString(ARTWORK_URL_KEY))) {
                    return SoundcloudParsingHelper.getAllImagesFromArtworkOrAvatarUrl(artworkUrl);
                }
                JsonObject creator = trackObject.getObject(USER_KEY);
                String creatorAvatar = creator.getString(AVATAR_URL_KEY);
                if (Utils.isNullOrEmpty(creatorAvatar)) continue;
                return SoundcloudParsingHelper.getAllImagesFromArtworkOrAvatarUrl(creatorAvatar);
            }
        }
        catch (Exception artworkUrl22) {
            // empty catch block
        }
        try {
            return SoundcloudParsingHelper.getAllImagesFromArtworkOrAvatarUrl(this.itemObject.getObject(USER_KEY).getString(AVATAR_URL_KEY));
        }
        catch (Exception e) {
            throw new ParsingException("Failed to extract playlist thumbnails", e);
        }
    }

    @Override
    public String getUploaderName() throws ParsingException {
        try {
            return this.itemObject.getObject(USER_KEY).getString("username");
        }
        catch (Exception e) {
            throw new ParsingException("Failed to extract playlist uploader", e);
        }
    }

    @Override
    public String getUploaderUrl() {
        return this.itemObject.getObject(USER_KEY).getString("permalink_url");
    }

    @Override
    public boolean isUploaderVerified() {
        return this.itemObject.getObject(USER_KEY).getBoolean("verified");
    }

    @Override
    public long getStreamCount() {
        return this.itemObject.getLong("track_count");
    }
}

