/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.soundcloud.linkHandler;

import java.io.IOException;
import java.util.List;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ExtractionException;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ReCaptchaException;
import org.watermedia.shaded.schabi.newpipe.extractor.linkhandler.SearchQueryHandlerFactory;
import org.watermedia.shaded.schabi.newpipe.extractor.services.soundcloud.SoundcloudParsingHelper;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.Utils;

public final class SoundcloudSearchQueryHandlerFactory
extends SearchQueryHandlerFactory {
    private static final SoundcloudSearchQueryHandlerFactory INSTANCE = new SoundcloudSearchQueryHandlerFactory();
    public static final String TRACKS = "tracks";
    public static final String USERS = "users";
    public static final String PLAYLISTS = "playlists";
    public static final String ALL = "all";
    public static final int ITEMS_PER_PAGE = 10;

    private SoundcloudSearchQueryHandlerFactory() {
    }

    public static SoundcloudSearchQueryHandlerFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public String getUrl(String id2, List<String> contentFilter, String sortFilter) throws ParsingException, UnsupportedOperationException {
        try {
            Object url = "https://api-v2.soundcloud.com/search";
            if (!contentFilter.isEmpty()) {
                switch (contentFilter.get(0)) {
                    case "tracks": {
                        url = (String)url + "/tracks";
                        break;
                    }
                    case "users": {
                        url = (String)url + "/users";
                        break;
                    }
                    case "playlists": {
                        url = (String)url + "/playlists";
                        break;
                    }
                }
            }
            return (String)url + "?q=" + Utils.encodeUrlUtf8(id2) + "&client_id=" + SoundcloudParsingHelper.clientId() + "&limit=10&offset=0";
        }
        catch (ReCaptchaException e) {
            throw new ParsingException("ReCaptcha required", e);
        }
        catch (IOException | ExtractionException e) {
            throw new ParsingException("Could not get client id", e);
        }
    }

    @Override
    public String[] getAvailableContentFilter() {
        return new String[]{ALL, TRACKS, USERS, PLAYLISTS};
    }
}

