/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.extractors;

import java.util.List;
import org.watermedia.shaded.com.grack.nanojson.JsonObject;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.schabi.newpipe.extractor.Image;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.playlist.PlaylistInfo;
import org.watermedia.shaded.schabi.newpipe.extractor.playlist.PlaylistInfoItemExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.YoutubeParsingHelper;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.linkHandler.YoutubePlaylistLinkHandlerFactory;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.Utils;

public class YoutubeMixOrPlaylistLockupInfoItemExtractor
implements PlaylistInfoItemExtractor {
    @Nonnull
    private final JsonObject lockupViewModel;
    @Nonnull
    private final JsonObject thumbnailViewModel;
    @Nonnull
    private final JsonObject lockupMetadataViewModel;
    @Nonnull
    private final JsonObject firstMetadataRow;
    @Nonnull
    private PlaylistInfo.PlaylistType playlistType;

    public YoutubeMixOrPlaylistLockupInfoItemExtractor(@Nonnull JsonObject lockupViewModel) {
        this.lockupViewModel = lockupViewModel;
        this.thumbnailViewModel = lockupViewModel.getObject("contentImage").getObject("collectionThumbnailViewModel").getObject("primaryThumbnail").getObject("thumbnailViewModel");
        this.lockupMetadataViewModel = lockupViewModel.getObject("metadata").getObject("lockupMetadataViewModel");
        this.firstMetadataRow = this.lockupMetadataViewModel.getObject("metadata").getObject("contentMetadataViewModel").getArray("metadataRows").getObject(0);
        try {
            this.playlistType = YoutubeParsingHelper.extractPlaylistTypeFromPlaylistId(this.getPlaylistId());
        }
        catch (ParsingException e) {
            this.playlistType = PlaylistInfo.PlaylistType.NORMAL;
        }
    }

    @Override
    public String getUploaderName() throws ParsingException {
        return this.firstMetadataRow.getArray("metadataParts").getObject(0).getObject("text").getString("content");
    }

    @Override
    public String getUploaderUrl() throws ParsingException {
        if (this.playlistType != PlaylistInfo.PlaylistType.NORMAL) {
            return null;
        }
        return YoutubeParsingHelper.getUrlFromNavigationEndpoint(this.firstMetadataRow.getArray("metadataParts").getObject(0).getObject("text").getArray("org.watermedia.shaded.commandRuns").getObject(0).getObject("onTap").getObject("innertubeCommand"));
    }

    @Override
    public boolean isUploaderVerified() throws ParsingException {
        if (this.playlistType != PlaylistInfo.PlaylistType.NORMAL) {
            return false;
        }
        return YoutubeParsingHelper.hasArtistOrVerifiedIconBadgeAttachment(this.firstMetadataRow.getArray("metadataParts").getObject(0).getObject("text").getArray("attachmentRuns"));
    }

    @Override
    public long getStreamCount() throws ParsingException {
        if (this.playlistType != PlaylistInfo.PlaylistType.NORMAL) {
            return -2L;
        }
        try {
            return Long.parseLong(Utils.removeNonDigitCharacters(this.thumbnailViewModel.getArray("overlays").stream().filter(JsonObject.class::isInstance).map(JsonObject.class::cast).filter(overlay -> overlay.has("thumbnailOverlayBadgeViewModel")).findFirst().orElseThrow(() -> new ParsingException("Could not get thumbnailOverlayBadgeViewModel")).getObject("thumbnailOverlayBadgeViewModel").getArray("thumbnailBadges").stream().filter(JsonObject.class::isInstance).map(JsonObject.class::cast).filter(badge -> badge.has("thumbnailBadgeViewModel")).findFirst().orElseThrow(() -> new ParsingException("Could not get thumbnailBadgeViewModel")).getObject("thumbnailBadgeViewModel").getString("text")));
        }
        catch (Exception e) {
            throw new ParsingException("Could not get playlist stream count", e);
        }
    }

    @Override
    public String getName() throws ParsingException {
        return this.lockupMetadataViewModel.getObject("title").getString("content");
    }

    @Override
    public String getUrl() throws ParsingException {
        if (this.playlistType == PlaylistInfo.PlaylistType.NORMAL) {
            try {
                return YoutubePlaylistLinkHandlerFactory.getInstance().getUrl(this.getPlaylistId());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return YoutubeParsingHelper.getUrlFromNavigationEndpoint(this.lockupViewModel.getObject("rendererContext").getObject("org.watermedia.shaded.commandContext").getObject("onTap").getObject("innertubeCommand"));
    }

    @Override
    @Nonnull
    public List<Image> getThumbnails() throws ParsingException {
        return YoutubeParsingHelper.getImagesFromThumbnailsArray(this.thumbnailViewModel.getObject("image").getArray("sources"));
    }

    @Override
    @Nonnull
    public PlaylistInfo.PlaylistType getPlaylistType() throws ParsingException {
        return this.playlistType;
    }

    private String getPlaylistId() throws ParsingException {
        String id2 = this.lockupViewModel.getString("contentId");
        if (Utils.isNullOrEmpty(id2)) {
            id2 = this.lockupViewModel.getObject("rendererContext").getObject("org.watermedia.shaded.commandContext").getObject("watchEndpoint").getString("playlistId");
        }
        if (Utils.isNullOrEmpty(id2)) {
            throw new ParsingException("Could not get playlist ID");
        }
        return id2;
    }
}

