/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.extractors;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.watermedia.shaded.com.grack.nanojson.JsonArray;
import org.watermedia.shaded.com.grack.nanojson.JsonObject;
import org.watermedia.shaded.com.grack.nanojson.JsonParser;
import org.watermedia.shaded.com.grack.nanojson.JsonParserException;
import org.watermedia.shaded.com.grack.nanojson.JsonStringWriter;
import org.watermedia.shaded.com.grack.nanojson.JsonWriter;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.javax.annotation.Nullable;
import org.watermedia.shaded.schabi.newpipe.extractor.InfoItem;
import org.watermedia.shaded.schabi.newpipe.extractor.ListExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.MetaInfo;
import org.watermedia.shaded.schabi.newpipe.extractor.MultiInfoItemsCollector;
import org.watermedia.shaded.schabi.newpipe.extractor.Page;
import org.watermedia.shaded.schabi.newpipe.extractor.StreamingService;
import org.watermedia.shaded.schabi.newpipe.extractor.downloader.Downloader;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ExtractionException;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.linkhandler.SearchQueryHandler;
import org.watermedia.shaded.schabi.newpipe.extractor.search.SearchExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.YoutubeParsingHelper;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.extractors.YoutubeMusicAlbumOrPlaylistInfoItemExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.extractors.YoutubeMusicArtistInfoItemExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.extractors.YoutubeMusicSongOrVideoInfoItemExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.JsonUtils;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.Utils;

public class YoutubeMusicSearchExtractor
extends SearchExtractor {
    private JsonObject initialData;
    private List<JsonObject> cachedItemSectionRendererContents;

    public YoutubeMusicSearchExtractor(StreamingService service, SearchQueryHandler linkHandler) {
        super(service, linkHandler);
    }

    @Override
    public void onFetchPage(@Nonnull Downloader downloader) throws IOException, ExtractionException {
        String params;
        String url = "https://music.youtube.com/youtubei/v1/search?prettyPrint=false";
        switch (this.getLinkHandler().getContentFilters().get(0)) {
            case "music_songs": {
                params = "Eg-KAQwIARAAGAAgACgAMABqChAEEAUQAxAKEAk%3D";
                break;
            }
            case "music_videos": {
                params = "Eg-KAQwIABABGAAgACgAMABqChAEEAUQAxAKEAk%3D";
                break;
            }
            case "music_albums": {
                params = "Eg-KAQwIABAAGAEgACgAMABqChAEEAUQAxAKEAk%3D";
                break;
            }
            case "music_playlists": {
                params = "Eg-KAQwIABAAGAAgACgBMABqChAEEAUQAxAKEAk%3D";
                break;
            }
            case "music_artists": {
                params = "Eg-KAQwIABAAGAAgASgAMABqChAEEAUQAxAKEAk%3D";
                break;
            }
            default: {
                params = null;
            }
        }
        byte[] json = ((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)JsonWriter.string().object()).object("context")).object("client")).value("clientName", "WEB_REMIX")).value("clientVersion", YoutubeParsingHelper.getYoutubeMusicClientVersion())).value("hl", "en-GB")).value("gl", this.getExtractorContentCountry().getCountryCode())).value("platform", "DESKTOP")).value("utcOffsetMinutes", 0)).end()).object("request")).array("internalExperimentFlags")).end()).value("useSsl", true)).end()).object("user")).value("lockedSafetyMode", false)).end()).end()).value("query", this.getSearchString())).value("params", params)).end()).done().getBytes(StandardCharsets.UTF_8);
        String responseBody = YoutubeParsingHelper.getValidJsonResponseBody(this.getDownloader().postWithContentTypeJson("https://music.youtube.com/youtubei/v1/search?prettyPrint=false", YoutubeParsingHelper.getYoutubeMusicHeaders(), json));
        try {
            this.initialData = JsonParser.object().from(responseBody);
        }
        catch (JsonParserException e) {
            throw new ParsingException("Could not parse JSON", e);
        }
    }

    private List<JsonObject> getItemSectionRendererContents() {
        if (this.cachedItemSectionRendererContents != null) {
            return this.cachedItemSectionRendererContents;
        }
        this.cachedItemSectionRendererContents = this.initialData.getObject("contents").getObject("tabbedSearchResultsRenderer").getArray("tabs").getObject(0).getObject("tabRenderer").getObject("content").getObject("sectionListRenderer").getArray("contents").stream().filter(JsonObject.class::isInstance).map(JsonObject.class::cast).map(c -> c.getObject("itemSectionRenderer")).filter(isr -> !isr.isEmpty()).map(isr -> isr.getArray("contents").getObject(0)).collect(Collectors.toList());
        return this.cachedItemSectionRendererContents;
    }

    @Override
    @Nonnull
    public String getSearchSuggestion() throws ParsingException {
        for (JsonObject obj : this.getItemSectionRendererContents()) {
            JsonObject didYouMeanRenderer = obj.getObject("didYouMeanRenderer");
            if (!didYouMeanRenderer.isEmpty()) {
                return YoutubeParsingHelper.getTextFromObject(didYouMeanRenderer.getObject("correctedQuery"));
            }
            JsonObject showingResultsForRenderer = obj.getObject("showingResultsForRenderer");
            if (showingResultsForRenderer.isEmpty()) continue;
            return JsonUtils.getString(showingResultsForRenderer, "correctedQueryEndpoint.searchEndpoint.query");
        }
        return "";
    }

    @Override
    public boolean isCorrectedSearch() throws ParsingException {
        return this.getItemSectionRendererContents().stream().anyMatch(obj -> obj.has("showingResultsForRenderer"));
    }

    @Override
    @Nonnull
    public List<MetaInfo> getMetaInfo() {
        return Collections.emptyList();
    }

    @Override
    @Nonnull
    public ListExtractor.InfoItemsPage<InfoItem> getInitialPage() throws IOException, ExtractionException {
        MultiInfoItemsCollector collector = new MultiInfoItemsCollector(this.getServiceId());
        JsonArray contents = JsonUtils.getArray(JsonUtils.getArray(this.initialData, "contents.tabbedSearchResultsRenderer.tabs").getObject(0), "tabRenderer.content.sectionListRenderer.contents");
        Page nextPage = null;
        for (Object content : contents) {
            if (!((JsonObject)content).has("musicShelfRenderer")) continue;
            JsonObject musicShelfRenderer = ((JsonObject)content).getObject("musicShelfRenderer");
            this.collectMusicStreamsFrom(collector, musicShelfRenderer.getArray("contents"));
            nextPage = this.getNextPageFrom(musicShelfRenderer.getArray("continuations"));
        }
        return new ListExtractor.InfoItemsPage<InfoItem>(collector, nextPage);
    }

    @Override
    public ListExtractor.InfoItemsPage<InfoItem> getPage(Page page) throws IOException, ExtractionException {
        JsonObject ajaxJson;
        if (page == null || Utils.isNullOrEmpty(page.getUrl())) {
            throw new IllegalArgumentException("Page doesn't contain an URL");
        }
        MultiInfoItemsCollector collector = new MultiInfoItemsCollector(this.getServiceId());
        byte[] json = ((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)JsonWriter.string().object()).object("context")).object("client")).value("clientName", "WEB_REMIX")).value("clientVersion", YoutubeParsingHelper.getYoutubeMusicClientVersion())).value("hl", "en-GB")).value("gl", this.getExtractorContentCountry().getCountryCode())).value("platform", "DESKTOP")).value("utcOffsetMinutes", 0)).end()).object("request")).array("internalExperimentFlags")).end()).value("useSsl", true)).end()).object("user")).value("lockedSafetyMode", false)).end()).end()).end()).done().getBytes(StandardCharsets.UTF_8);
        String responseBody = YoutubeParsingHelper.getValidJsonResponseBody(this.getDownloader().postWithContentTypeJson(page.getUrl(), YoutubeParsingHelper.getYoutubeMusicHeaders(), json));
        try {
            ajaxJson = JsonParser.object().from(responseBody);
        }
        catch (JsonParserException e) {
            throw new ParsingException("Could not parse JSON", e);
        }
        JsonObject musicShelfContinuation = ajaxJson.getObject("continuationContents").getObject("musicShelfContinuation");
        this.collectMusicStreamsFrom(collector, musicShelfContinuation.getArray("contents"));
        JsonArray continuations = musicShelfContinuation.getArray("continuations");
        return new ListExtractor.InfoItemsPage<InfoItem>(collector, this.getNextPageFrom(continuations));
    }

    private void collectMusicStreamsFrom(MultiInfoItemsCollector collector, @Nonnull JsonArray videos) {
        String searchType = this.getLinkHandler().getContentFilters().get(0);
        videos.stream().filter(JsonObject.class::isInstance).map(JsonObject.class::cast).map(item -> item.getObject("musicResponsiveListItemRenderer", null)).filter(Objects::nonNull).forEachOrdered(infoItem -> {
            String displayPolicy = infoItem.getString("musicItemRendererDisplayPolicy", "");
            if (displayPolicy.equals("MUSIC_ITEM_RENDERER_DISPLAY_POLICY_GREY_OUT")) {
                return;
            }
            JsonArray descriptionElements = infoItem.getArray("flexColumns").getObject(1).getObject("musicResponsiveListItemFlexColumnRenderer").getObject("text").getArray("runs");
            switch (searchType) {
                case "music_songs": 
                case "music_videos": {
                    collector.commit(new YoutubeMusicSongOrVideoInfoItemExtractor((JsonObject)infoItem, descriptionElements, searchType));
                    break;
                }
                case "music_artists": {
                    collector.commit(new YoutubeMusicArtistInfoItemExtractor((JsonObject)infoItem));
                    break;
                }
                case "music_albums": 
                case "music_playlists": {
                    collector.commit(new YoutubeMusicAlbumOrPlaylistInfoItemExtractor((JsonObject)infoItem, descriptionElements, searchType));
                }
            }
        });
    }

    @Nullable
    private Page getNextPageFrom(JsonArray continuations) {
        if (Utils.isNullOrEmpty(continuations)) {
            return null;
        }
        JsonObject nextContinuationData = continuations.getObject(0).getObject("nextContinuationData");
        String continuation = nextContinuationData.getString("continuation");
        return new Page("https://music.youtube.com/youtubei/v1/search?ctoken=" + continuation + "&continuation=" + continuation + "&prettyPrint=false");
    }
}

